"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNetworkFromEntity = exports.convertAnomaliesToNetwork = void 0;
var _types = require("../types");
var _get_network_from_influencers = require("../influencers/get_network_from_influencers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertAnomaliesToNetwork = (anomalies, jobNameById, ip) => {
  if (anomalies == null) {
    return [];
  } else {
    return anomalies.anomalies.reduce((accum, item) => {
      if ((0, _types.isDestinationOrSource)(item.entityName) && getNetworkFromEntity(item, ip)) {
        var _jobNameById$item$job;
        return [...accum, {
          ip: item.entityValue,
          type: item.entityName,
          jobName: (_jobNameById$item$job = jobNameById[item.jobId]) !== null && _jobNameById$item$job !== void 0 ? _jobNameById$item$job : item.jobId,
          anomaly: item
        }];
      } else {
        const network = (0, _get_network_from_influencers.getNetworkFromInfluencers)(item.influencers, ip);
        if (network != null) {
          var _jobNameById$item$job2;
          return [...accum, {
            ip: network.ip,
            type: network.type,
            jobName: (_jobNameById$item$job2 = jobNameById[item.jobId]) !== null && _jobNameById$item$job2 !== void 0 ? _jobNameById$item$job2 : item.jobId,
            anomaly: item
          }];
        } else {
          return accum;
        }
      }
    }, []);
  }
};
exports.convertAnomaliesToNetwork = convertAnomaliesToNetwork;
const getNetworkFromEntity = (anomaly, ip) => {
  if ((0, _types.isDestinationOrSource)(anomaly.entityName)) {
    if (ip == null) {
      return true;
    } else {
      return anomaly.entityValue === ip;
    }
  } else {
    return false;
  }
};
exports.getNetworkFromEntity = getNetworkFromEntity;