"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIdsFromUrl = void 0;
var _zod = require("@kbn/zod");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const schema = _zod.z.object({
  ids: _zod.z.string().array()
});
const useIdsFromUrl = () => {
  const [searchParams, setSearchParams] = (0, _reactRouterDomV5Compat.useSearchParams)();
  const ids = (0, _react.useMemo)(() => {
    try {
      if (!searchParams.has('id')) {
        return [];
      }
      const parsed = schema.parse({
        ids: searchParams.getAll('id').flatMap(id => id.split(',')).map(id => decodeURIComponent(id.trim()))
      });
      return parsed.ids;
    } catch (e) {
      return [];
    }
  }, [searchParams]);
  const setIdsUrl = (0, _react.useCallback)(newIds => {
    if (newIds.length) {
      searchParams.set('id', newIds.join(','));
    } else {
      searchParams.delete('id');
    }
    setSearchParams(searchParams);
  }, [searchParams, setSearchParams]);
  return {
    ids,
    setIdsUrl
  };
};
exports.useIdsFromUrl = useIdsFromUrl;