"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isUserName = exports.getUserFlyoutPanelProps = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _constants = require("../../../../../flyout/entity_details/shared/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isUserName = fieldName => fieldName === 'user.name';
exports.isUserName = isUserName;
const getUserFlyoutPanelProps = ({
  contextId,
  userName
}) => ({
  id: _constants.UserPanelKey,
  params: {
    userName,
    contextID: contextId,
    scopeId: _securitysolutionDataTable.TableId.alertsOnAlertsPage
  }
});
exports.getUserFlyoutPanelProps = getUserFlyoutPanelProps;