"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssetInventoryGrouping = exports.isAssetsRootGroupingAggregation = exports.getDefaultQuery = void 0;
var _react = require("react");
var uuid = _interopRequireWildcard(require("uuid"));
var _grouping = require("@kbn/grouping");
var _src = require("@kbn/grouping/src");
var _esQuery = require("@kbn/es-query");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _analytics = require("@kbn/analytics");
var _dedent = _interopRequireDefault(require("dedent"));
var _data_view_context = require("../../hooks/data_view_context");
var _constants = require("../../constants");
var _asset_inventory_group_renderer = require("./utils/asset_inventory_group_renderer");
var _use_fetch_grouped_data = require("./use_fetch_grouped_data");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_GROUPING_LEVELS = 3;
const defaultGroupingOptions = [{
  label: _translations.GROUPING_LABELS.ASSET_CRITICALITY,
  key: _constants.ASSET_GROUPING_OPTIONS.ASSET_CRITICALITY
}, {
  label: _translations.GROUPING_LABELS.ENTITY_TYPE,
  key: _constants.ASSET_GROUPING_OPTIONS.ENTITY_TYPE
}, {
  label: _translations.GROUPING_LABELS.CLOUD_ACCOUNT,
  key: _constants.ASSET_GROUPING_OPTIONS.CLOUD_ACCOUNT
}];
const getDefaultQuery = ({
  query,
  filters,
  pageFilters
}) => ({
  query,
  filters,
  pageFilters: [],
  sort: [[]]
});
exports.getDefaultQuery = getDefaultQuery;
const getTermAggregation = (key, field) => ({
  [key]: {
    terms: {
      field,
      size: 1
    }
  }
});
const getAggregationsByGroupField = field => {
  if ((0, _grouping.isNoneGroup)([field])) {
    return [];
  }
  const aggMetrics = [{
    groupByField: {
      cardinality: {
        field
      }
    }
  }];
  switch (field) {
    case _constants.ASSET_GROUPING_OPTIONS.ASSET_CRITICALITY:
      return [...aggMetrics, getTermAggregation('assetCriticality', _constants.ASSET_FIELDS.ASSET_CRITICALITY)];
    case _constants.ASSET_GROUPING_OPTIONS.ENTITY_TYPE:
      return [...aggMetrics, getTermAggregation('entityType', _constants.ASSET_FIELDS.ENTITY_TYPE)];
    case _constants.ASSET_GROUPING_OPTIONS.CLOUD_ACCOUNT:
      return [...aggMetrics, getTermAggregation('accountId', _constants.ASSET_FIELDS.CLOUD_ACCOUNT_ID), getTermAggregation('accountName', _constants.ASSET_FIELDS.CLOUD_ACCOUNT_NAME), getTermAggregation('cloudProvider', _constants.ASSET_FIELDS.CLOUD_PROVIDER)];
  }
  return aggMetrics;
};

/**
 * Type Guard for checking if the given source is a AssetsRootGroupingAggregation
 */
const isAssetsRootGroupingAggregation = groupData => {
  var _groupData$unitsCount;
  return typeof groupData === 'object' && 'unitsCount' in groupData && ((_groupData$unitsCount = groupData.unitsCount) === null || _groupData$unitsCount === void 0 ? void 0 : _groupData$unitsCount.value) !== undefined;
};

/**
 * Utility hook to get the latest assets grouping data for the assets page
 */
exports.isAssetsRootGroupingAggregation = isAssetsRootGroupingAggregation;
const useAssetInventoryGrouping = ({
  state,
  groupFilters = [],
  selectedGroup
}) => {
  var _groupData$unitsCount2;
  const {
    query,
    setUrlQuery,
    pageSize,
    pageIndex
  } = state;
  const {
    dataView,
    dataViewIsLoading
  } = (0, _data_view_context.useDataViewContext)();
  const grouping = (0, _grouping.useGrouping)({
    componentProps: {
      unit: _translations.assetsUnit,
      groupPanelRenderer: _asset_inventory_group_renderer.groupPanelRenderer,
      getGroupStats: _asset_inventory_group_renderer.groupStatsRenderer,
      groupsUnit: _translations.assetGroupsUnit
    },
    defaultGroupingOptions,
    fields: dataViewIsLoading ? [] : dataView.fields,
    groupingId: _constants.LOCAL_STORAGE_ASSETS_GROUPING_KEY,
    maxGroupingLevels: MAX_GROUPING_LEVELS,
    title: _translations.groupingTitle,
    onGroupChange: ({
      groupByFields
    }) => {
      setUrlQuery({
        groupBy: groupByFields
      });
      _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metrics.GROUP_BY_CLICK);
    }
  });
  const additionalFilters = (0, _esQuery.buildEsQuery)(dataView, [], groupFilters);
  const currentSelectedGroup = selectedGroup || grouping.selectedGroups[0];
  const isNoneSelected = (0, _grouping.isNoneGroup)(grouping.selectedGroups);
  // This is recommended by the grouping component to cover an edge case where `selectedGroup` has multiple values
  const uniqueValue = (0, _react.useMemo)(() => `${selectedGroup}-${uuid.v4()}`, [selectedGroup]);
  const groupingQuery = (0, _react.useMemo)(() => ({
    ...(0, _grouping.getGroupingQuery)({
      additionalFilters: query ? [query, additionalFilters] : [additionalFilters],
      groupByField: currentSelectedGroup,
      uniqueValue,
      pageNumber: pageIndex * pageSize,
      size: pageSize,
      sort: [{
        groupByField: {
          order: 'desc'
        }
      }],
      statsAggregations: getAggregationsByGroupField(currentSelectedGroup),
      rootAggregations: [{
        ...(!(0, _grouping.isNoneGroup)([currentSelectedGroup]) && {
          nullGroupItems: currentSelectedGroup === _constants.ASSET_FIELDS.ASSET_CRITICALITY ? {
            filter: {
              bool: {
                should: [{
                  term: {
                    [_constants.ASSET_FIELDS.ASSET_CRITICALITY]: 'deleted'
                  }
                }, {
                  bool: {
                    must_not: {
                      exists: {
                        field: _constants.ASSET_FIELDS.ASSET_CRITICALITY
                      }
                    }
                  }
                }],
                minimum_should_match: 1
              }
            }
          } : {
            missing: {
              field: currentSelectedGroup
            }
          }
        })
      }]
    }),
    runtime_mappings: {
      groupByField: {
        type: 'keyword',
        script: {
          source: (0, _dedent.default)(`
          def groupValues = [];
          if (doc.containsKey(params['selectedGroup']) && !doc[params['selectedGroup']].empty) {
            groupValues = doc[params['selectedGroup']];
          }
          // If selectedGroup is 'asset.criticality', treat 'deleted' as undefined group
          boolean treatAsUndefined = false;
          int count = groupValues.size();
          if (params['selectedGroup'] == 'asset.criticality') {
            boolean isDeleted = false;
            for (def v : groupValues) {
              if (v == 'deleted') {
                isDeleted = true;
                break;
              }
            }
            treatAsUndefined = (count == 0 || count > 100 || isDeleted);
          } else {
            treatAsUndefined = (count == 0 || count > 100);
          }
          if (treatAsUndefined) {
            emit(params['uniqueValue']);
          } else {
            emit(groupValues.join(params['uniqueValue']));
          }
        `),
          params: {
            selectedGroup: currentSelectedGroup,
            uniqueValue
          }
        }
      }
    }
  }), [currentSelectedGroup, uniqueValue, additionalFilters, query, pageIndex, pageSize]);
  const {
    data,
    isFetching
  } = (0, _use_fetch_grouped_data.useFetchGroupedData)({
    query: groupingQuery,
    enabled: !isNoneSelected
  });
  const groupData = (0, _react.useMemo)(() => (0, _src.parseGroupingQuery)(currentSelectedGroup, uniqueValue, data), [data, currentSelectedGroup, uniqueValue]);
  const isEmptyResults = !isFetching && isAssetsRootGroupingAggregation(groupData) && ((_groupData$unitsCount2 = groupData.unitsCount) === null || _groupData$unitsCount2 === void 0 ? void 0 : _groupData$unitsCount2.value) === 0;
  return {
    groupData,
    grouping,
    isFetching,
    selectedGroup,
    isGroupSelected: !isNoneSelected,
    isEmptyResults
  };
};
exports.useAssetInventoryGrouping = useAssetInventoryGrouping;