"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Client = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _coreHttpCommon = require("@kbn/core-http-common");
var _shared = require("@kbn/openapi-common/shared");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: API client for quickstart
 *   version: Bundle (no version)
 */

class Client {
  constructor(options) {
    (0, _defineProperty2.default)(this, "kbnClient", void 0);
    (0, _defineProperty2.default)(this, "log", void 0);
    this.kbnClient = options.kbnClient;
    this.log = options.log;
  }
  /**
    * Migrations favor data integrity over shard size. Consequently, unused or orphaned indices are artifacts of
  the migration process. A successful migration will result in both the old and new indices being present.
  As such, the old, orphaned index can (and likely should) be deleted.
  While you can delete these indices manually,
  the endpoint accomplishes this task by applying a deletion policy to the relevant index, causing it to be deleted
  after 30 days. It also deletes other artifacts specific to the migration implementation.
     */
  async alertsMigrationCleanup(props) {
    this.log.info(`${new Date().toISOString()} Calling API AlertsMigrationCleanup`);
    return this.kbnClient.request({
      path: '/api/detection_engine/signals/migration',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'DELETE',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async applyEntityEngineDataviewIndices() {
    this.log.info(`${new Date().toISOString()} Calling API ApplyEntityEngineDataviewIndices`);
    return this.kbnClient.request({
      path: '/api/entity_store/engines/apply_dataview_indices',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async assetCriticalityGetPrivileges() {
    this.log.info(`${new Date().toISOString()} Calling API AssetCriticalityGetPrivileges`);
    return this.kbnClient.request({
      path: '/internal/asset_criticality/privileges',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Ensures that the packages needed for prebuilt detection rules to work are installed and up to date
   */
  async bootstrapPrebuiltRules() {
    this.log.info(`${new Date().toISOString()} Calling API BootstrapPrebuiltRules`);
    return this.kbnClient.request({
      path: '/internal/detection_engine/prebuilt_rules/_bootstrap',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'POST'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Bulk upsert up to 1000 asset criticality records.
  If asset criticality records already exist for the specified entities, those records are overwritten with the specified values. If asset criticality records don't exist for the specified entities, new records are created.
     */
  async bulkUpsertAssetCriticalityRecords(props) {
    this.log.info(`${new Date().toISOString()} Calling API BulkUpsertAssetCriticalityRecords`);
    return this.kbnClient.request({
      path: '/api/asset_criticality/bulk',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Create a clean draft Timeline or Timeline template for the current user.
  > info
  > If the user already has a draft Timeline, the existing draft Timeline is cleared and returned.
     */
  async cleanDraftTimelines(props) {
    this.log.info(`${new Date().toISOString()} Calling API CleanDraftTimelines`);
    return this.kbnClient.request({
      path: '/api/timeline/_draft',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Cleaning up the the Risk Engine by removing the indices, mapping and transforms
   */
  async cleanUpRiskEngine() {
    this.log.info(`${new Date().toISOString()} Calling API CleanUpRiskEngine`);
    return this.kbnClient.request({
      path: '/api/risk_score/engine/dangerously_delete_data',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'DELETE'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Configuring the Risk Engine Saved Object
   */
  async configureRiskEngineSavedObject(props) {
    this.log.info(`${new Date().toISOString()} Calling API ConfigureRiskEngineSavedObject`);
    return this.kbnClient.request({
      path: '/api/risk_score/engine/saved_object/configure',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'PATCH',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Copies and returns a timeline or timeline template.
     */
  async copyTimeline(props) {
    this.log.info(`${new Date().toISOString()} Calling API CopyTimeline`);
    return this.kbnClient.request({
      path: '/api/timeline/_copy',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async createAlertsIndex() {
    this.log.info(`${new Date().toISOString()} Calling API CreateAlertsIndex`);
    return this.kbnClient.request({
      path: '/api/detection_engine/index',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Initiate a migration of detection alerts.
  Migrations are initiated per index. While the process is neither destructive nor interferes with existing data, it may be resource-intensive. As such, it is recommended that you plan your migrations accordingly.
     */
  async createAlertsMigration(props) {
    this.log.info(`${new Date().toISOString()} Calling API CreateAlertsMigration`);
    return this.kbnClient.request({
      path: '/api/detection_engine/signals/migration',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Create or update an asset criticality record for a specific entity.
  If a record already exists for the specified entity, that record is overwritten with the specified value. If a record doesn't exist for the specified entity, a new record is created.
     */
  async createAssetCriticalityRecord(props) {
    this.log.info(`${new Date().toISOString()} Calling API CreateAssetCriticalityRecord`);
    return this.kbnClient.request({
      path: '/api/asset_criticality',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async createEntitySource(props) {
    this.log.info(`${new Date().toISOString()} Calling API CreateEntitySource`);
    return this.kbnClient.request({
      path: '/api/entity_analytics/monitoring/entity_source',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async createPrivilegesImportIndex(props) {
    this.log.info(`${new Date().toISOString()} Calling API CreatePrivilegesImportIndex`);
    return this.kbnClient.request({
      path: '/api/entity_analytics/monitoring/privileges/indices',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'PUT',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async createPrivMonUser(props) {
    this.log.info(`${new Date().toISOString()} Calling API CreatePrivMonUser`);
    return this.kbnClient.request({
      path: '/api/entity_analytics/monitoring/users',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Create a new detection rule.
  > warn
  > When used with [API key](https://www.elastic.co/docs/deploy-manage/api-keys) authentication, the user's key gets assigned to the affected rules. If the user's key gets deleted or the user becomes inactive, the rules will stop running.
  > If the API key that is used for authorization has different privileges than the key that created or most recently updated the rule, the rule behavior might change.
  You can create the following types of rules:
  * **Custom query**: Searches the defined indices and creates an alert when a document matches the rule's KQL query.
  * **Event correlation**: Searches the defined indices and creates an alert when results match an [Event Query Language (EQL)](https://www.elastic.co/guide/en/elasticsearch/reference/current/eql.html) query.
  * **Threshold**: Searches the defined indices and creates an alert when the number of times the specified field's value meets the threshold during a single execution. When there are multiple values that meet the threshold, an alert is generated for each value.
  For example, if the threshold `field` is `source.ip` and its `value` is `10`, an alert is generated for every source IP address that appears in at least 10 of the rule's search results. If you're interested, see [Terms Aggregation](https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-bucket-terms-aggregation.html) for more information.
  * **Indicator match**: Creates an alert when fields match values defined in the specified [Elasticsearch index](https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-create-index.html). For example, you can create an index for IP addresses and use this index to create an alert whenever an event's `destination.ip` equals a value in the index. The index's field mappings should be [ECS-compliant](https://www.elastic.co/guide/en/ecs/current/ecs-reference.html).
  * **New terms**: Generates an alert for each new term detected in source documents within a specified time range.
  * **ES|QL**: Uses [Elasticsearch Query Language (ES|QL)](https://www.elastic.co/guide/en/elasticsearch/reference/current/esql.html) to find events and aggregate search results.
  * **Machine learning rules**: Creates an alert when a machine learning job discovers an anomaly above the defined threshold.
  > info
  > To create machine learning rules, you must have the [appropriate license](https://www.elastic.co/subscriptions) or use a [cloud deployment](https://cloud.elastic.co/registration). Additionally, for the machine learning rule to function correctly, the associated machine learning job must be running.
  To retrieve machine learning job IDs, which are required to create machine learning jobs, call the [Elasticsearch Get jobs API](https://www.elastic.co/guide/en/elasticsearch/reference/current/ml-get-job.html). Machine learning jobs that contain `siem` in the `groups` field can be used to create rules:
  ```json
  ...
  "job_id": "linux_anomalous_network_activity_ecs",
  "job_type": "anomaly_detector",
  "job_version": "7.7.0",
  "groups": [
  "auditbeat",
  "process",
  "siem"
  ],
  ...
  ```
  Additionally, you can set up notifications for when rules create alerts. The notifications use the [Alerting and Actions framework](https://www.elastic.co/guide/en/kibana/current/alerting-getting-started.html). Each action type requires a connector. Connectors store the information required to send notifications via external systems. The following connector types are supported for rule notifications:
  * Slack
  * Email
  * PagerDuty
  * Webhook
  * Microsoft Teams
  * IBM Resilient
  * Jira
  * ServiceNow ITSM
  > info
  > For more information on PagerDuty fields, see [Send a v2 Event](https://developer.pagerduty.com/docs/events-api-v2/trigger-events/).
  To retrieve connector IDs, which are required to configure rule notifications, call the [Find objects API](https://www.elastic.co/guide/en/kibana/current/saved-objects-api-find.html) with `"type": "action"` in the request payload.
  For detailed information on Kibana actions and alerting, and additional API calls, see:
  * [Alerting API](https://www.elastic.co/docs/api/doc/kibana/group/endpoint-alerting)
  * [Alerting and Actions framework](https://www.elastic.co/guide/en/kibana/current/alerting-getting-started.html)
  * [Connectors API](https://www.elastic.co/docs/api/doc/kibana/group/endpoint-connectors)
     */
  async createRule(props) {
    this.log.info(`${new Date().toISOString()} Calling API CreateRule`);
    return this.kbnClient.request({
      path: '/api/detection_engine/rules',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Creates a new rule migration and returns the corresponding migration_id
   */
  async createRuleMigration(props) {
    this.log.info(`${new Date().toISOString()} Calling API CreateRuleMigration`);
    return this.kbnClient.request({
      path: '/internal/siem_migrations/rules',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'PUT',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Adds original vendor rules to an already existing migration. Can be called multiple times to add more rules
   */
  async createRuleMigrationRules(props) {
    this.log.info(`${new Date().toISOString()} Calling API CreateRuleMigrationRules`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/internal/siem_migrations/rules/{migration_id}/rules', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Create a new Timeline or Timeline template.
   */
  async createTimelines(props) {
    this.log.info(`${new Date().toISOString()} Calling API CreateTimelines`);
    return this.kbnClient.request({
      path: '/api/timeline',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async createUpdateProtectionUpdatesNote(props) {
    this.log.info(`${new Date().toISOString()} Calling API CreateUpdateProtectionUpdatesNote`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/api/endpoint/protection_updates_note/{package_policy_id}', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async deleteAlertsIndex() {
    this.log.info(`${new Date().toISOString()} Calling API DeleteAlertsIndex`);
    return this.kbnClient.request({
      path: '/api/detection_engine/index',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'DELETE'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Delete the asset criticality record for a specific entity.
   */
  async deleteAssetCriticalityRecord(props) {
    this.log.info(`${new Date().toISOString()} Calling API DeleteAssetCriticalityRecord`);
    return this.kbnClient.request({
      path: '/api/asset_criticality',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'DELETE',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async deleteEntityEngine(props) {
    this.log.info(`${new Date().toISOString()} Calling API DeleteEntityEngine`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/api/entity_store/engines/{entityType}', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'DELETE',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async deleteEntitySource(props) {
    this.log.info(`${new Date().toISOString()} Calling API DeleteEntitySource`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/api/entity_analytics/monitoring/entity_source/{id}', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'DELETE'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async deleteMonitoringEngine(props) {
    this.log.info(`${new Date().toISOString()} Calling API DeleteMonitoringEngine`);
    return this.kbnClient.request({
      path: '/api/entity_analytics/monitoring/engine/delete',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'DELETE',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Delete a note from a Timeline using the note ID.
   */
  async deleteNote(props) {
    this.log.info(`${new Date().toISOString()} Calling API DeleteNote`);
    return this.kbnClient.request({
      path: '/api/note',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'DELETE',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async deletePrivMonUser(props) {
    this.log.info(`${new Date().toISOString()} Calling API DeletePrivMonUser`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/api/entity_analytics/monitoring/users/{id}', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'DELETE'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Delete a detection rule using the `rule_id` or `id` field.
  The URL query must include one of the following:
  * `id` - `DELETE /api/detection_engine/rules?id=<id>`
  * `rule_id`- `DELETE /api/detection_engine/rules?rule_id=<rule_id>`
  The difference between the `id` and `rule_id` is that the `id` is a unique rule identifier that is randomly generated when a rule is created and cannot be set, whereas `rule_id` is a stable rule identifier that can be assigned during rule creation.
     */
  async deleteRule(props) {
    this.log.info(`${new Date().toISOString()} Calling API DeleteRule`);
    return this.kbnClient.request({
      path: '/api/detection_engine/rules',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'DELETE',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Deletes a rule migration document stored in the system given the rule migration id
   */
  async deleteRuleMigration(props) {
    this.log.info(`${new Date().toISOString()} Calling API DeleteRuleMigration`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/internal/siem_migrations/rules/{migration_id}', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'DELETE'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Delete one or more Timelines or Timeline templates.
   */
  async deleteTimelines(props) {
    this.log.info(`${new Date().toISOString()} Calling API DeleteTimelines`);
    return this.kbnClient.request({
      path: '/api/timeline',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'DELETE',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Calculates and persists Risk Scores for an entity, returning the calculated risk score.
   */
  async deprecatedTriggerRiskScoreCalculation(props) {
    this.log.info(`${new Date().toISOString()} Calling API DeprecatedTriggerRiskScoreCalculation`);
    return this.kbnClient.request({
      path: '/api/risk_scores/calculation/entity',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async disableMonitoringEngine() {
    this.log.info(`${new Date().toISOString()} Calling API DisableMonitoringEngine`);
    return this.kbnClient.request({
      path: '/api/entity_analytics/monitoring/engine/disable',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async disableRiskEngine() {
    this.log.info(`${new Date().toISOString()} Calling API DisableRiskEngine`);
    return this.kbnClient.request({
      path: '/internal/risk_score/engine/disable',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'POST'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async enableRiskEngine() {
    this.log.info(`${new Date().toISOString()} Calling API EnableRiskEngine`);
    return this.kbnClient.request({
      path: '/internal/risk_score/engine/enable',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'POST'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Run a shell command on an endpoint.
   */
  async endpointExecuteAction(props) {
    this.log.info(`${new Date().toISOString()} Calling API EndpointExecuteAction`);
    return this.kbnClient.request({
      path: '/api/endpoint/action/execute',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Download a file from an endpoint. 
  > info
  > To construct a `file_id`, combine the `action_id` and `agent_id` values using a dot separator:
  > {`file_id`} = {`action_id`}`.`{`agent_id`}
     */
  async endpointFileDownload(props) {
    this.log.info(`${new Date().toISOString()} Calling API EndpointFileDownload`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/api/endpoint/action/{action_id}/file/{file_id}/download', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Get information for the specified file using the file ID.
  > info
  > To construct a `file_id`, combine the `action_id` and `agent_id` values using a dot separator:
  > {`file_id`} = {`action_id`}`.`{`agent_id`}
     */
  async endpointFileInfo(props) {
    this.log.info(`${new Date().toISOString()} Calling API EndpointFileInfo`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/api/endpoint/action/{action_id}/file/{file_id}', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Get the details of a response action using the action ID.
   */
  async endpointGetActionsDetails(props) {
    this.log.info(`${new Date().toISOString()} Calling API EndpointGetActionsDetails`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/api/endpoint/action/{action_id}', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Get a list of all response actions.
   */
  async endpointGetActionsList(props) {
    this.log.info(`${new Date().toISOString()} Calling API EndpointGetActionsList`);
    return this.kbnClient.request({
      path: '/api/endpoint/action',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Get a response actions state, which reports whether encryption is enabled.
   */
  async endpointGetActionsState() {
    this.log.info(`${new Date().toISOString()} Calling API EndpointGetActionsState`);
    return this.kbnClient.request({
      path: '/api/endpoint/action/state',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Get the status of response actions for the specified agent IDs.
   */
  async endpointGetActionsStatus(props) {
    this.log.info(`${new Date().toISOString()} Calling API EndpointGetActionsStatus`);
    return this.kbnClient.request({
      path: '/api/endpoint/action_status',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Get a file from an endpoint.
   */
  async endpointGetFileAction(props) {
    this.log.info(`${new Date().toISOString()} Calling API EndpointGetFileAction`);
    return this.kbnClient.request({
      path: '/api/endpoint/action/get_file',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Get a list of all processes running on an endpoint.
   */
  async endpointGetProcessesAction(props) {
    this.log.info(`${new Date().toISOString()} Calling API EndpointGetProcessesAction`);
    return this.kbnClient.request({
      path: '/api/endpoint/action/running_procs',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Isolate an endpoint from the network. The endpoint remains isolated until it's released.
   */
  async endpointIsolateAction(props) {
    this.log.info(`${new Date().toISOString()} Calling API EndpointIsolateAction`);
    return this.kbnClient.request({
      path: '/api/endpoint/action/isolate',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Terminate a running process on an endpoint.
   */
  async endpointKillProcessAction(props) {
    this.log.info(`${new Date().toISOString()} Calling API EndpointKillProcessAction`);
    return this.kbnClient.request({
      path: '/api/endpoint/action/kill_process',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Scan a specific file or directory on an endpoint for malware.
   */
  async endpointScanAction(props) {
    this.log.info(`${new Date().toISOString()} Calling API EndpointScanAction`);
    return this.kbnClient.request({
      path: '/api/endpoint/action/scan',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Suspend a running process on an endpoint.
   */
  async endpointSuspendProcessAction(props) {
    this.log.info(`${new Date().toISOString()} Calling API EndpointSuspendProcessAction`);
    return this.kbnClient.request({
      path: '/api/endpoint/action/suspend_process',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Release an isolated endpoint, allowing it to rejoin a network.
   */
  async endpointUnisolateAction(props) {
    this.log.info(`${new Date().toISOString()} Calling API EndpointUnisolateAction`);
    return this.kbnClient.request({
      path: '/api/endpoint/action/unisolate',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Upload a file to an endpoint.
   */
  async endpointUploadAction(props) {
    this.log.info(`${new Date().toISOString()} Calling API EndpointUploadAction`);
    return this.kbnClient.request({
      path: '/api/endpoint/action/upload',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.attachment
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async entityStoreGetPrivileges() {
    this.log.info(`${new Date().toISOString()} Calling API EntityStoreGetPrivileges`);
    return this.kbnClient.request({
      path: '/internal/entity_store/privileges',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Export detection rules to an `.ndjson` file. The following configuration items are also included in the `.ndjson` file:
  - Actions
  - Exception lists
  > info
  > Rule actions and connectors are included in the exported file, but sensitive information about the connector (such as authentication credentials) is not included. You must re-add missing connector details after importing detection rules.
  > You can use Kibana’s [Saved Objects](https://www.elastic.co/guide/en/kibana/current/managing-saved-objects.html) UI (Stack Management → Kibana → Saved Objects) or the Saved Objects APIs (experimental) to [export](https://www.elastic.co/docs/api/doc/kibana/operation/operation-exportsavedobjectsdefault) and [import](https://www.elastic.co/docs/api/doc/kibana/operation/operation-importsavedobjectsdefault) any necessary connectors before importing detection rules.
  > Similarly, any value lists used for rule exceptions are not included in rule exports or imports. Use the [Manage value lists](https://www.elastic.co/guide/en/security/current/value-lists-exceptions.html#manage-value-lists) UI (Rules → Detection rules (SIEM) → Manage value lists) to export and import value lists separately.
     */
  async exportRules(props) {
    this.log.info(`${new Date().toISOString()} Calling API ExportRules`);
    return this.kbnClient.request({
      path: '/api/detection_engine/rules/_export',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body,
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Export Timelines as an NDJSON file.
   */
  async exportTimelines(props) {
    this.log.info(`${new Date().toISOString()} Calling API ExportTimelines`);
    return this.kbnClient.request({
      path: '/api/timeline/_export',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body,
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Finalize successful migrations of detection alerts. This replaces the original index's alias with the successfully migrated index's alias.
  The endpoint is idempotent; therefore, it can safely be used to poll a given migration and, upon completion,
  finalize it.
     */
  async finalizeAlertsMigration(props) {
    this.log.info(`${new Date().toISOString()} Calling API FinalizeAlertsMigration`);
    return this.kbnClient.request({
      path: '/api/detection_engine/signals/finalize_migration',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * List asset criticality records, paging, sorting and filtering as needed.
   */
  async findAssetCriticalityRecords(props) {
    this.log.info(`${new Date().toISOString()} Calling API FindAssetCriticalityRecords`);
    return this.kbnClient.request({
      path: '/api/asset_criticality/list',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Retrieve a paginated list of detection rules. By default, the first page is returned, with 20 results per page.
   */
  async findRules(props) {
    this.log.info(`${new Date().toISOString()} Calling API FindRules`);
    return this.kbnClient.request({
      path: '/api/detection_engine/rules/_find',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Retrieves the rule migrations stats for all migrations stored in the system
   */
  async getAllStatsRuleMigration() {
    this.log.info(`${new Date().toISOString()} Calling API GetAllStatsRuleMigration`);
    return this.kbnClient.request({
      path: '/internal/siem_migrations/rules/stats',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Get the asset criticality record for a specific entity.
   */
  async getAssetCriticalityRecord(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetAssetCriticalityRecord`);
    return this.kbnClient.request({
      path: '/api/asset_criticality',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async getAssetCriticalityStatus() {
    this.log.info(`${new Date().toISOString()} Calling API GetAssetCriticalityStatus`);
    return this.kbnClient.request({
      path: '/internal/asset_criticality/status',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Get the details of the draft Timeline  or Timeline template for the current user. If the user doesn't have a draft Timeline, an empty Timeline is returned.
   */
  async getDraftTimelines(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetDraftTimelines`);
    return this.kbnClient.request({
      path: '/api/timeline/_draft',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async getEndpointMetadataList(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetEndpointMetadataList`);
    return this.kbnClient.request({
      path: '/api/endpoint/metadata',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async getEndpointSuggestions(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetEndpointSuggestions`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/internal/api/endpoint/suggestions/{suggestion_type}', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async getEntityEngine(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetEntityEngine`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/api/entity_store/engines/{entityType}', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async getEntitySource(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetEntitySource`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/api/entity_analytics/monitoring/entity_source/{id}', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async getEntityStoreStatus(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetEntityStoreStatus`);
    return this.kbnClient.request({
      path: '/api/entity_store/status',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Get all notes for a given document.
   */
  async getNotes(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetNotes`);
    return this.kbnClient.request({
      path: '/api/note',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async getPolicyResponse(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetPolicyResponse`);
    return this.kbnClient.request({
      path: '/api/endpoint/policy_response',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async getPrivilegedAccessDetectionPackageStatus() {
    this.log.info(`${new Date().toISOString()} Calling API GetPrivilegedAccessDetectionPackageStatus`);
    return this.kbnClient.request({
      path: '/api/entity_analytics/privileged_user_monitoring/pad/status',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async getProtectionUpdatesNote(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetProtectionUpdatesNote`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/api/endpoint/protection_updates_note/{package_policy_id}', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Returns the status of both the legacy transform-based risk engine, as well as the new risk engine
   */
  async getRiskEngineStatus() {
    this.log.info(`${new Date().toISOString()} Calling API GetRiskEngineStatus`);
    return this.kbnClient.request({
      path: '/internal/risk_score/engine/status',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async getRuleExecutionEvents(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetRuleExecutionEvents`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/internal/detection_engine/rules/{ruleId}/execution/events', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'PUT',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async getRuleExecutionResults(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetRuleExecutionResults`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/internal/detection_engine/rules/{ruleId}/execution/results', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'PUT',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Retrieves the rule migration document stored in the system given the rule migration id
   */
  async getRuleMigration(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetRuleMigration`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/internal/siem_migrations/rules/{migration_id}', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Retrieves all related integrations
   */
  async getRuleMigrationIntegrations() {
    this.log.info(`${new Date().toISOString()} Calling API GetRuleMigrationIntegrations`);
    return this.kbnClient.request({
      path: '/internal/siem_migrations/rules/integrations',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Retrieves the stats of all the integrations for all the rule migrations, including the number of rules associated with the integration
   */
  async getRuleMigrationIntegrationsStats() {
    this.log.info(`${new Date().toISOString()} Calling API GetRuleMigrationIntegrationsStats`);
    return this.kbnClient.request({
      path: '/internal/siem_migrations/rules/integrations/stats',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Retrieves all available prebuilt rules (installed and installable)
   */
  async getRuleMigrationPrebuiltRules(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetRuleMigrationPrebuiltRules`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/internal/siem_migrations/rules/{migration_id}/prebuilt_rules', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Identifies the privileges required for a SIEM rules migration and returns the missing privileges
   */
  async getRuleMigrationPrivileges() {
    this.log.info(`${new Date().toISOString()} Calling API GetRuleMigrationPrivileges`);
    return this.kbnClient.request({
      path: '/internal/siem_migrations/rules/missing_privileges',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Retrieves resources for an existing SIEM rules migration
   */
  async getRuleMigrationResources(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetRuleMigrationResources`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/internal/siem_migrations/rules/{migration_id}/resources', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Identifies missing resources from all the rules of an existing SIEM rules migration
   */
  async getRuleMigrationResourcesMissing(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetRuleMigrationResourcesMissing`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/internal/siem_migrations/rules/{migration_id}/resources/missing', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Retrieves the the list of rules included in a migration given the migration id
   */
  async getRuleMigrationRules(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetRuleMigrationRules`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/internal/siem_migrations/rules/{migration_id}/rules', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Retrieves the stats of a SIEM rules migration using the migration id provided
   */
  async getRuleMigrationStats(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetRuleMigrationStats`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/internal/siem_migrations/rules/{migration_id}/stats', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Retrieves the translation stats of a SIEM rules migration using the migration id provided
   */
  async getRuleMigrationTranslationStats(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetRuleMigrationTranslationStats`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/internal/siem_migrations/rules/{migration_id}/translation_stats', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Get the details of an existing saved Timeline or Timeline template.
   */
  async getTimeline(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetTimeline`);
    return this.kbnClient.request({
      path: '/api/timeline',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Get a list of all saved Timelines or Timeline templates.
   */
  async getTimelines(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetTimelines`);
    return this.kbnClient.request({
      path: '/api/timelines',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async getWorkflowInsights(props) {
    this.log.info(`${new Date().toISOString()} Calling API GetWorkflowInsights`);
    return this.kbnClient.request({
      path: '/internal/api/endpoint/workflow_insights',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Import detection rules from an `.ndjson` file, including actions and exception lists. The request must include:
  - The `Content-Type: multipart/form-data` HTTP header.
  - A link to the `.ndjson` file containing the rules.
  > warn
  > When used with [API key](https://www.elastic.co/docs/deploy-manage/api-keys) authentication, the user's key gets assigned to the affected rules. If the user's key gets deleted or the user becomes inactive, the rules will stop running.
  > If the API key that is used for authorization has different privileges than the key that created or most recently updated the rule, the rule behavior might change.
  > info
  > To import rules with actions, you need at least Read privileges for the Action and Connectors feature. To overwrite or add new connectors, you need All privileges for the Actions and Connectors feature. To import rules without actions, you don’t need Actions and Connectors privileges. Refer to [Enable and access detections](https://www.elastic.co/guide/en/security/current/detections-permissions-section.html#enable-detections-ui) for more information.
  > info
  > Rule actions and connectors are included in the exported file, but sensitive information about the connector (such as authentication credentials) is not included. You must re-add missing connector details after importing detection rules.
  > You can use Kibana’s [Saved Objects](https://www.elastic.co/guide/en/kibana/current/managing-saved-objects.html) UI (Stack Management → Kibana → Saved Objects) or the Saved Objects APIs (experimental) to [export](https://www.elastic.co/docs/api/doc/kibana/operation/operation-exportsavedobjectsdefault) and [import](https://www.elastic.co/docs/api/doc/kibana/operation/operation-importsavedobjectsdefault) any necessary connectors before importing detection rules.
  > Similarly, any value lists used for rule exceptions are not included in rule exports or imports. Use the [Manage value lists](https://www.elastic.co/guide/en/security/current/value-lists-exceptions.html#manage-value-lists) UI (Rules → Detection rules (SIEM) → Manage value lists) to export and import value lists separately.
     */
  async importRules(props) {
    this.log.info(`${new Date().toISOString()} Calling API ImportRules`);
    return this.kbnClient.request({
      path: '/api/detection_engine/rules/_import',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.attachment,
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Import Timelines.
   */
  async importTimelines(props) {
    this.log.info(`${new Date().toISOString()} Calling API ImportTimelines`);
    return this.kbnClient.request({
      path: '/api/timeline/_import',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async initEntityEngine(props) {
    this.log.info(`${new Date().toISOString()} Calling API InitEntityEngine`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/api/entity_store/engines/{entityType}/init', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async initEntityStore(props) {
    this.log.info(`${new Date().toISOString()} Calling API InitEntityStore`);
    return this.kbnClient.request({
      path: '/api/entity_store/enable',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async initMonitoringEngine() {
    this.log.info(`${new Date().toISOString()} Calling API InitMonitoringEngine`);
    return this.kbnClient.request({
      path: '/api/entity_analytics/monitoring/engine/init',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Initializes the Risk Engine by creating the necessary indices and mappings, removing old transforms, and starting the new risk engine
   */
  async initRiskEngine() {
    this.log.info(`${new Date().toISOString()} Calling API InitRiskEngine`);
    return this.kbnClient.request({
      path: '/internal/risk_score/engine/init',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'POST'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Installs migration rules
   */
  async installMigrationRules(props) {
    this.log.info(`${new Date().toISOString()} Calling API InstallMigrationRules`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/internal/siem_migrations/rules/{migration_id}/install', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Install and update all Elastic prebuilt detection rules and Timelines.
  This endpoint allows you to install and update prebuilt detection rules and Timelines provided by Elastic. 
  When you call this endpoint, it will:
  - Install any new prebuilt detection rules that are not currently installed in your system.
  - Update any existing prebuilt detection rules that have been modified or improved by Elastic.
  - Install any new prebuilt Timelines that are not currently installed in your system.
  - Update any existing prebuilt Timelines that have been modified or improved by Elastic.
  This ensures that your detection engine is always up-to-date with the latest rules and Timelines, 
  providing you with the most current and effective threat detection capabilities.
     */
  async installPrebuiltRulesAndTimelines() {
    this.log.info(`${new Date().toISOString()} Calling API InstallPrebuiltRulesAndTimelines`);
    return this.kbnClient.request({
      path: '/api/detection_engine/rules/prepackaged',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'PUT'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Install or update prepackaged Timelines.
   */
  async installPrepackedTimelines(props) {
    this.log.info(`${new Date().toISOString()} Calling API InstallPrepackedTimelines`);
    return this.kbnClient.request({
      path: '/api/timeline/_prepackaged',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async installPrivilegedAccessDetectionPackage() {
    this.log.info(`${new Date().toISOString()} Calling API InstallPrivilegedAccessDetectionPackage`);
    return this.kbnClient.request({
      path: '/api/entity_analytics/privileged_user_monitoring/pad/install',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async internalUploadAssetCriticalityRecords(props) {
    this.log.info(`${new Date().toISOString()} Calling API InternalUploadAssetCriticalityRecords`);
    return this.kbnClient.request({
      path: '/internal/asset_criticality/upload_csv',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'POST',
      body: props.attachment
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * List entities records, paging, sorting and filtering as needed.
   */
  async listEntities(props) {
    this.log.info(`${new Date().toISOString()} Calling API ListEntities`);
    return this.kbnClient.request({
      path: '/api/entity_store/entities/list',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async listEntityEngines() {
    this.log.info(`${new Date().toISOString()} Calling API ListEntityEngines`);
    return this.kbnClient.request({
      path: '/api/entity_store/engines',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async listEntitySources(props) {
    this.log.info(`${new Date().toISOString()} Calling API ListEntitySources`);
    return this.kbnClient.request({
      path: '/api/entity_analytics/monitoring/entity_source/list',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async listPrivMonUsers(props) {
    this.log.info(`${new Date().toISOString()} Calling API ListPrivMonUsers`);
    return this.kbnClient.request({
      path: '/api/entity_analytics/monitoring/users/list',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Update specific fields of an existing detection rule using the `rule_id` or `id` field.
  The difference between the `id` and `rule_id` is that the `id` is a unique rule identifier that is randomly generated when a rule is created and cannot be set, whereas `rule_id` is a stable rule identifier that can be assigned during rule creation.
  > warn
  > When used with [API key](https://www.elastic.co/docs/deploy-manage/api-keys) authentication, the user's key gets assigned to the affected rules. If the user's key gets deleted or the user becomes inactive, the rules will stop running.
  > If the API key that is used for authorization has different privileges than the key that created or most recently updated the rule, the rule behavior might change.
     */
  async patchRule(props) {
    this.log.info(`${new Date().toISOString()} Calling API PatchRule`);
    return this.kbnClient.request({
      path: '/api/detection_engine/rules',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'PATCH',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Update an existing Timeline. You can update the title, description, date range, pinned events, pinned queries, and/or pinned saved queries of an existing Timeline.
   */
  async patchTimeline(props) {
    this.log.info(`${new Date().toISOString()} Calling API PatchTimeline`);
    return this.kbnClient.request({
      path: '/api/timeline',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'PATCH',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Apply a bulk action, such as bulk edit, duplicate, or delete, to multiple detection rules. The bulk action is applied to all rules that match the query or to the rules listed by their IDs.
  The edit action allows you to add, delete, or set tags, index patterns, investigation fields, rule actions and schedules for multiple rules at once. 
  The edit action is idempotent, meaning that if you add a tag to a rule that already has that tag, no changes are made. The same is true for other edit actions, for example removing an index pattern that is not specified in a rule will not result in any changes. The only exception is the `add_rule_actions` and `set_rule_actions` action, which is non-idempotent. This means that if you add or set a rule action to a rule that already has that action, a new action is created with a new unique ID.
  > warn
  > When used with [API key](https://www.elastic.co/docs/deploy-manage/api-keys) authentication, the user's key gets assigned to the affected rules. If the user's key gets deleted or the user becomes inactive, the rules will stop running.
  > If the API key that is used for authorization has different privileges than the key that created or most recently updated the rule, the rule behavior might change.
     */
  async performRulesBulkAction(props) {
    this.log.info(`${new Date().toISOString()} Calling API PerformRulesBulkAction`);
    return this.kbnClient.request({
      path: '/api/detection_engine/rules/_bulk_action',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body,
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Favorite a Timeline or Timeline template for the current user.
   */
  async persistFavoriteRoute(props) {
    this.log.info(`${new Date().toISOString()} Calling API PersistFavoriteRoute`);
    return this.kbnClient.request({
      path: '/api/timeline/_favorite',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'PATCH',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Add a note to a Timeline or update an existing note.
   */
  async persistNoteRoute(props) {
    this.log.info(`${new Date().toISOString()} Calling API PersistNoteRoute`);
    return this.kbnClient.request({
      path: '/api/note',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'PATCH',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Pin/unpin an event to/from an existing Timeline.
   */
  async persistPinnedEventRoute(props) {
    this.log.info(`${new Date().toISOString()} Calling API PersistPinnedEventRoute`);
    return this.kbnClient.request({
      path: '/api/pinned_event',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'PATCH',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Calculates and returns a list of Risk Scores, sorted by identifier_type and risk score.
   */
  async previewRiskScore(props) {
    this.log.info(`${new Date().toISOString()} Calling API PreviewRiskScore`);
    return this.kbnClient.request({
      path: '/internal/risk_score/preview',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async privmonBulkUploadUsersCsv(props) {
    this.log.info(`${new Date().toISOString()} Calling API PrivmonBulkUploadUsersCSV`);
    return this.kbnClient.request({
      path: '/api/entity_analytics/monitoring/users/_csv',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.attachment
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async privMonHealth() {
    this.log.info(`${new Date().toISOString()} Calling API PrivMonHealth`);
    return this.kbnClient.request({
      path: '/api/entity_analytics/monitoring/privileges/health',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Check if the current user has all required permissions for Privilege Monitoring
   */
  async privMonPrivileges() {
    this.log.info(`${new Date().toISOString()} Calling API PrivMonPrivileges`);
    return this.kbnClient.request({
      path: '/api/entity_analytics/monitoring/privileges/privileges',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async readAlertsIndex() {
    this.log.info(`${new Date().toISOString()} Calling API ReadAlertsIndex`);
    return this.kbnClient.request({
      path: '/api/detection_engine/index',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Retrieve indices that contain detection alerts of a particular age, along with migration information for each of those indices.
   */
  async readAlertsMigrationStatus(props) {
    this.log.info(`${new Date().toISOString()} Calling API ReadAlertsMigrationStatus`);
    return this.kbnClient.request({
      path: '/api/detection_engine/signals/migration_status',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Retrieve the status of all Elastic prebuilt detection rules and Timelines. 
  This endpoint provides detailed information about the number of custom rules, installed prebuilt rules, available prebuilt rules that are not installed, outdated prebuilt rules, installed prebuilt timelines, available prebuilt timelines that are not installed, and outdated prebuilt timelines.
     */
  async readPrebuiltRulesAndTimelinesStatus() {
    this.log.info(`${new Date().toISOString()} Calling API ReadPrebuiltRulesAndTimelinesStatus`);
    return this.kbnClient.request({
      path: '/api/detection_engine/rules/prepackaged/_status',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Retrieves whether or not the user is authenticated, and the user's Kibana
  space and index privileges, which determine if the user can create an
  index for the Elastic Security alerts generated by
  detection engine rules.
     */
  async readPrivileges() {
    this.log.info(`${new Date().toISOString()} Calling API ReadPrivileges`);
    return this.kbnClient.request({
      path: '/api/detection_engine/privileges',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async readRiskEngineSettings() {
    this.log.info(`${new Date().toISOString()} Calling API ReadRiskEngineSettings`);
    return this.kbnClient.request({
      path: '/internal/risk_score/engine/settings',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Retrieve a detection rule using the `rule_id` or `id` field.
  The URL query must include one of the following:
  * `id` - `GET /api/detection_engine/rules?id=<id>`
  * `rule_id` - `GET /api/detection_engine/rules?rule_id=<rule_id>`
  The difference between the `id` and `rule_id` is that the `id` is a unique rule identifier that is randomly generated when a rule is created and cannot be set, whereas `rule_id` is a stable rule identifier that can be assigned during rule creation.
     */
  async readRule(props) {
    this.log.info(`${new Date().toISOString()} Calling API ReadRule`);
    return this.kbnClient.request({
      path: '/api/detection_engine/rules',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * List all unique tags from all detection rules.
   */
  async readTags() {
    this.log.info(`${new Date().toISOString()} Calling API ReadTags`);
    return this.kbnClient.request({
      path: '/api/detection_engine/tags',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async resolveTimeline(props) {
    this.log.info(`${new Date().toISOString()} Calling API ResolveTimeline`);
    return this.kbnClient.request({
      path: '/api/timeline/resolve',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async riskEngineGetPrivileges() {
    this.log.info(`${new Date().toISOString()} Calling API RiskEngineGetPrivileges`);
    return this.kbnClient.request({
      path: '/internal/risk_engine/privileges',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'GET'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async rulePreview(props) {
    this.log.info(`${new Date().toISOString()} Calling API RulePreview`);
    return this.kbnClient.request({
      path: '/api/detection_engine/rules/preview',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body,
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async runEntityAnalyticsMigrations() {
    this.log.info(`${new Date().toISOString()} Calling API RunEntityAnalyticsMigrations`);
    return this.kbnClient.request({
      path: '/internal/entity_analytics/migrations/run',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'POST'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Run a shell command on an endpoint.
   */
  async runScriptAction(props) {
    this.log.info(`${new Date().toISOString()} Calling API RunScriptAction`);
    return this.kbnClient.request({
      path: '/api/endpoint/action/runscript',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Schedule the risk scoring engine to run as soon as possible. You can use this to recalculate entity risk scores after updating their asset criticality.
   */
  async scheduleRiskEngineNow() {
    this.log.info(`${new Date().toISOString()} Calling API ScheduleRiskEngineNow`);
    return this.kbnClient.request({
      path: '/api/risk_score/engine/schedule_now',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Find and/or aggregate detection alerts that match the given query.
   */
  async searchAlerts(props) {
    this.log.info(`${new Date().toISOString()} Calling API SearchAlerts`);
    return this.kbnClient.request({
      path: '/api/detection_engine/signals/search',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async searchPrivilegesIndices(props) {
    this.log.info(`${new Date().toISOString()} Calling API SearchPrivilegesIndices`);
    return this.kbnClient.request({
      path: '/api/entity_analytics/monitoring/privileges/indices',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'GET',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Assign users to detection alerts, and unassign them from alerts.
  > info
  > You cannot add and remove the same assignee in the same request.
     */
  async setAlertAssignees(props) {
    this.log.info(`${new Date().toISOString()} Calling API SetAlertAssignees`);
    return this.kbnClient.request({
      path: '/api/detection_engine/signals/assignees',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Set the status of one or more detection alerts.
   */
  async setAlertsStatus(props) {
    this.log.info(`${new Date().toISOString()} Calling API SetAlertsStatus`);
    return this.kbnClient.request({
      path: '/api/detection_engine/signals/status',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * And tags to detection alerts, and remove them from alerts.
  > info
  > You cannot add and remove the same alert tag in the same request.
     */
  async setAlertTags(props) {
    this.log.info(`${new Date().toISOString()} Calling API SetAlertTags`);
    return this.kbnClient.request({
      path: '/api/detection_engine/signals/tags',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async startEntityEngine(props) {
    this.log.info(`${new Date().toISOString()} Calling API StartEntityEngine`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/api/entity_store/engines/{entityType}/start', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Starts a SIEM rules migration using the migration id provided
   */
  async startRuleMigration(props) {
    this.log.info(`${new Date().toISOString()} Calling API StartRuleMigration`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/internal/siem_migrations/rules/{migration_id}/start', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async stopEntityEngine(props) {
    this.log.info(`${new Date().toISOString()} Calling API StopEntityEngine`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/api/entity_store/engines/{entityType}/stop', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'POST'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Stops a running SIEM rules migration using the migration id provided
   */
  async stopRuleMigration(props) {
    this.log.info(`${new Date().toISOString()} Calling API StopRuleMigration`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/internal/siem_migrations/rules/{migration_id}/stop', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'POST'
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Suggests user profiles.
   */
  async suggestUserProfiles(props) {
    this.log.info(`${new Date().toISOString()} Calling API SuggestUserProfiles`);
    return this.kbnClient.request({
      path: '/internal/detection_engine/users/_find',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'POST',
      query: props.query
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Calculates and persists Risk Scores for an entity, returning the calculated risk score.
   */
  async triggerRiskScoreCalculation(props) {
    this.log.info(`${new Date().toISOString()} Calling API TriggerRiskScoreCalculation`);
    return this.kbnClient.request({
      path: '/internal/risk_score/calculation/entity',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async updateEntitySource(props) {
    this.log.info(`${new Date().toISOString()} Calling API UpdateEntitySource`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/api/entity_analytics/monitoring/entity_source/{id}', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'PUT',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async updatePrivMonUser(props) {
    this.log.info(`${new Date().toISOString()} Calling API UpdatePrivMonUser`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/api/entity_analytics/monitoring/users/{id}', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'PUT',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
    * Update a detection rule using the `rule_id` or `id` field. The original rule is replaced, and all unspecified fields are deleted.
  The difference between the `id` and `rule_id` is that the `id` is a unique rule identifier that is randomly generated when a rule is created and cannot be set, whereas `rule_id` is a stable rule identifier that can be assigned during rule creation.
  > warn
  > When used with [API key](https://www.elastic.co/docs/deploy-manage/api-keys) authentication, the user's key gets assigned to the affected rules. If the user's key gets deleted or the user becomes inactive, the rules will stop running.
  > If the API key that is used for authorization has different privileges than the key that created or most recently updated the rule, the rule behavior might change.
     */
  async updateRule(props) {
    this.log.info(`${new Date().toISOString()} Calling API UpdateRule`);
    return this.kbnClient.request({
      path: '/api/detection_engine/rules',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '2023-10-31'
      },
      method: 'PUT',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Updates rules migrations data
   */
  async updateRuleMigration(props) {
    this.log.info(`${new Date().toISOString()} Calling API UpdateRuleMigration`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/internal/siem_migrations/rules/{migration_id}', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'PATCH',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Updates rules migrations attributes
   */
  async updateRuleMigrationRules(props) {
    this.log.info(`${new Date().toISOString()} Calling API UpdateRuleMigrationRules`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/internal/siem_migrations/rules/{migration_id}/rules', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'PATCH',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async updateWorkflowInsight(props) {
    this.log.info(`${new Date().toISOString()} Calling API UpdateWorkflowInsight`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/internal/api/endpoint/workflow_insights/{insightId}', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'PUT',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  async uploadAssetCriticalityRecords(props) {
    this.log.info(`${new Date().toISOString()} Calling API UploadAssetCriticalityRecords`);
    return this.kbnClient.request({
      path: '/api/asset_criticality/upload_csv',
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'POST',
      body: props.attachment
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
  /**
   * Creates or updates resources for an existing SIEM rules migration
   */
  async upsertRuleMigrationResources(props) {
    this.log.info(`${new Date().toISOString()} Calling API UpsertRuleMigrationResources`);
    return this.kbnClient.request({
      path: (0, _shared.replaceParams)('/internal/siem_migrations/rules/{migration_id}/resources', props.params),
      headers: {
        [_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER]: '1'
      },
      method: 'POST',
      body: props.body
    }).catch(_securitysolutionUtils.catchAxiosErrorFormatAndThrow);
  }
}
exports.Client = Client;