"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildUserProfileApi = exports.buildSecurityApi = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildSecurityApi = ({
  getAuthc,
  audit
}) => {
  return {
    authc: {
      getCurrentUser: request => {
        return getAuthc().getCurrentUser(request);
      },
      apiKeys: {
        areAPIKeysEnabled: () => getAuthc().apiKeys.areAPIKeysEnabled(),
        areCrossClusterAPIKeysEnabled: () => getAuthc().apiKeys.areAPIKeysEnabled(),
        grantAsInternalUser: (request, createParams) => getAuthc().apiKeys.grantAsInternalUser(request, createParams),
        create: (request, createParams) => getAuthc().apiKeys.create(request, createParams),
        update: (request, updateParams) => getAuthc().apiKeys.update(request, updateParams),
        validate: apiKeyParams => getAuthc().apiKeys.validate(apiKeyParams),
        invalidate: (request, params) => getAuthc().apiKeys.invalidate(request, params),
        invalidateAsInternalUser: params => getAuthc().apiKeys.invalidateAsInternalUser(params)
      }
    },
    audit: {
      asScoped(request) {
        return audit.asScoped(request);
      },
      withoutRequest: {
        log: audit.withoutRequest.log,
        enabled: audit.withoutRequest.enabled,
        includeSavedObjectNames: audit.withoutRequest.includeSavedObjectNames
      }
    }
  };
};
exports.buildSecurityApi = buildSecurityApi;
const buildUserProfileApi = ({
  getUserProfile
}) => {
  return {
    getCurrent: params => getUserProfile().getCurrent(params),
    suggest: params => getUserProfile().suggest(params),
    bulkGet: params => getUserProfile().bulkGet(params),
    update: (uids, data) => getUserProfile().update(uids, data)
  };
};
exports.buildUserProfileApi = buildUserProfileApi;