"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSynonymsSets = void 0;
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../common/constants");
var _pagination = require("../../common/pagination");
var _api_routes = require("../../common/api_routes");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchSynonymsSets = (page = _pagination.DEFAULT_PAGE_VALUE) => {
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  return (0, _reactQuery.useQuery)({
    queryKey: [_constants.SYNONYMS_SETS_QUERY_KEY, page.from, page.size],
    queryFn: async () => {
      return await http.get(_api_routes.APIRoutes.SYNONYM_SETS, {
        query: {
          from: page.from,
          size: page.size
        }
      });
    },
    refetchOnWindowFocus: false,
    retry: false
  });
};
exports.useFetchSynonymsSets = useFetchSynonymsSets;