"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIndexForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateIndexForm = ({
  indexName,
  indexNameHasError,
  isLoading,
  onCreateIndex,
  onFileUpload,
  onIndexNameChange,
  showAPIKeyCreateLabel,
  userPrivileges
}) => {
  var _userPrivileges$privi, _userPrivileges$privi2, _userPrivileges$privi3;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "createIndexUIView",
    fullWidth: true,
    component: "form",
    onSubmit: onCreateIndex
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.name.label', {
      defaultMessage: 'Name your index'
    }),
    helpText: _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.name.helpText', {
      defaultMessage: 'Index names must be lowercase and can only contain hyphens and numbers'
    }),
    fullWidth: true,
    isInvalid: indexNameHasError
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    autoFocus: true,
    fullWidth: true,
    "data-test-subj": "indexNameField",
    name: "indexName",
    value: indexName,
    isInvalid: indexNameHasError,
    disabled: (userPrivileges === null || userPrivileges === void 0 ? void 0 : (_userPrivileges$privi = userPrivileges.privileges) === null || _userPrivileges$privi === void 0 ? void 0 : _userPrivileges$privi.canManageIndex) === false,
    onChange: onIndexNameChange,
    placeholder: _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.name.placeholder', {
      defaultMessage: 'Enter a name for your index'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: (userPrivileges === null || userPrivileges === void 0 ? void 0 : (_userPrivileges$privi2 = userPrivileges.privileges) === null || _userPrivileges$privi2 === void 0 ? void 0 : _userPrivileges$privi2.canManageIndex) === false ? /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.permissionTooltip', {
      defaultMessage: 'You do not have permission to create an index.'
    })) : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    iconSide: "left",
    iconType: "sparkles",
    "data-test-subj": "createIndexBtn",
    disabled: (userPrivileges === null || userPrivileges === void 0 ? void 0 : (_userPrivileges$privi3 = userPrivileges.privileges) === null || _userPrivileges$privi3 === void 0 ? void 0 : _userPrivileges$privi3.canManageIndex) === false || indexNameHasError || isLoading,
    isLoading: isLoading,
    type: "submit"
  }, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.action.text', {
    defaultMessage: 'Create my index'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, showAPIKeyCreateLabel && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    type: "key",
    color: "subdued"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "apiKeyLabel"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.apiKeyCreation.description', {
    defaultMessage: "We'll create an API key for this index"
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "documents"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.shared.createIndex.fileUpload.text",
    defaultMessage: "Already have some data? {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "uploadFileLink",
        onClick: onFileUpload
      }, _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.fileUpload.link', {
        defaultMessage: 'Upload a file'
      }))
    }
  })))))));
};
exports.CreateIndexForm = CreateIndexForm;