"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditableResult = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _results_fields = require("./results_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditableResult = ({
  leftSideItem,
  hasIndexSelector,
  onIndexSelectorChange,
  onIdSelectorChange,
  onDeleteDocument,
  onExpand,
  indices = [],
  fields = [],
  initialDocId = '',
  initialIndex = '',
  error,
  isLoading = false
}) => {
  const [isExpanded, setIsExpanded] = _react.default.useState(false);
  const [documentId, setDocumentId] = _react.default.useState(initialDocId);
  const [index, setIndex] = _react.default.useState(initialIndex);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "s",
    color: "plain"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, leftSideItem && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, leftSideItem), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "editableResultDocumentId",
    value: documentId,
    onChange: e => setDocumentId(e.target.value),
    onBlur: e => {
      if (onIdSelectorChange) {
        onIdSelectorChange(e.target.value);
      }
    },
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.sharedKbnSearchIndexDocuments.editableResult.documentIdPlaceholder', {
      defaultMessage: 'Document ID'
    })
  })), hasIndexSelector && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "editableResultIndexSelector",
    placeholder: _i18n.i18n.translate('xpack.sharedKbnSearchIndexDocuments.editableResult.selectIndexPlaceholder', {
      defaultMessage: 'Select index'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: indices.map(i => ({
      label: i,
      value: 'index'
    })),
    isClearable: false,
    selectedOptions: index ? [{
      label: index,
      value: 'index'
    }] : [],
    onChange: selected => {
      var _selected$;
      const selectedIndex = ((_selected$ = selected[0]) === null || _selected$ === void 0 ? void 0 : _selected$.label) || '';
      setIndex(selectedIndex);
      if (onIndexSelectorChange) {
        (0, _lodash.debounce)(() => {
          onIndexSelectorChange(selectedIndex);
        }, 300)();
      }
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexEnd",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, error && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    color: "danger"
  }), !error && hasIndexSelector && (isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    iconType: isExpanded ? 'fold' : 'unfold',
    color: "primary",
    "aria-label": isExpanded ? 'Collapse fields' : 'Expand fields',
    onClick: () => {
      if (onExpand && !isExpanded) {
        onExpand();
      }
      setIsExpanded(!isExpanded);
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    color: "danger",
    onClick: onDeleteDocument,
    "aria-label": "Delete document",
    "data-test-subj": "editableResultDeleteButton"
  })))))), !error && (fields === null || fields === void 0 ? void 0 : fields.length) > 0 && isExpanded && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "s",
    color: "plain"
  }, /*#__PURE__*/_react.default.createElement(_results_fields.ResultFields, {
    documentId: "12345",
    isExpanded: false,
    fields: fields
  }))), error && /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "s",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning"
  }), "\xA0", error)))));
};
exports.EditableResult = EditableResult;