"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toolToDescriptor = exports.toExecutableTool = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toExecutableTool = ({
  tool,
  runner,
  request
}) => {
  const {
    handler,
    ...toolParts
  } = tool;
  return {
    ...toolParts,
    execute: params => {
      return runner.runTool({
        ...params,
        toolId: tool.id,
        request
      });
    }
  };
};

/**
 * Remove all additional properties from a tool descriptor.
 *
 * Can be used to convert/clean tool registration for public-facing APIs.
 */
exports.toExecutableTool = toExecutableTool;
const toolToDescriptor = tool => {
  const {
    id,
    description,
    meta
  } = tool;
  return {
    id,
    description,
    meta
  };
};
exports.toolToDescriptor = toolToDescriptor;