"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createToolEventEmitter = exports.createAgentEventEmitter = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates a run event emitter sending events to the provided event handler.
 */
const createAgentEventEmitter = ({
  eventHandler,
  context
}) => {
  if (eventHandler === undefined) {
    return createNoopEventEmitter();
  }
  return {
    emit: internalEvent => {
      eventHandler(internalEvent);
    }
  };
};

/**
 * Creates a run event emitter sending events to the provided event handler.
 */
exports.createAgentEventEmitter = createAgentEventEmitter;
const createToolEventEmitter = ({
  eventHandler,
  context
}) => {
  if (eventHandler === undefined) {
    return createNoopEventEmitter();
  }
  return {
    emit: event => {
      eventHandler(event);
    }
  };
};
exports.createToolEventEmitter = createToolEventEmitter;
const createNoopEventEmitter = () => {
  return {
    emit: () => {}
  };
};