"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isConversationUpdatedEvent = exports.isConversationCreatedEvent = exports.ChatEventType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ChatEventType = exports.ChatEventType = /*#__PURE__*/function (ChatEventType) {
  ChatEventType["conversationCreated"] = "conversationCreated";
  ChatEventType["conversationUpdated"] = "conversationUpdated";
  return ChatEventType;
}({}); // conversation created
const isConversationCreatedEvent = event => {
  return event.type === ChatEventType.conversationCreated;
};

// conversation updated
exports.isConversationCreatedEvent = isConversationCreatedEvent;
const isConversationUpdatedEvent = event => {
  return event.type === ChatEventType.conversationUpdated;
};

/**
 * All types of events that can be emitted from the chat API.
 */
exports.isConversationUpdatedEvent = isConversationUpdatedEvent;