"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardTiles = DashboardTiles;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _dashboard_tile = require("./dashboard_tile");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DashboardTiles({
  title,
  isLoadingDashboards,
  dashboards,
  dataTestSubj
}) {
  const wrapWithHeader = component => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      "data-test-subj": dataTestSubj
    }, /*#__PURE__*/_react.default.createElement("h2", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "xs"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), component);
  };
  if (isLoadingDashboards) return wrapWithHeader(/*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null));
  if (!dashboards || !dashboards.length) return wrapWithHeader(/*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.observability.relatedDashboards.noDashboardsTextLabel', {
    defaultMessage: 'No dashboards'
  })));
  return wrapWithHeader(dashboards.map(({
    actionButtonProps,
    ...rest
  }) => /*#__PURE__*/_react.default.createElement(_dashboard_tile.DashboardTile, {
    key: rest.id,
    dashboard: rest,
    actionButtonProps: actionButtonProps
  })));
}