"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ML_PARTITION_FIELD_VALUE = exports.ML_PARTITION_FIELDS = exports.ML_JOB_ID = exports.ML_ANOMALY_RESULT_TYPE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Custom enum for anomaly result type
 */
const ML_ANOMALY_RESULT_TYPE = exports.ML_ANOMALY_RESULT_TYPE = {
  BUCKET: 'bucket',
  RECORD: 'record',
  INFLUENCER: 'influencer'
};

/**
 * Array of partition fields.
 */
const ML_PARTITION_FIELDS = exports.ML_PARTITION_FIELDS = ['partition_field', 'over_field', 'by_field'];

/**
 * Machine learning job id attribute name.
 */
const ML_JOB_ID = exports.ML_JOB_ID = 'job_id';

/**
 * Machine learning partition field value attribute name.
 */
const ML_PARTITION_FIELD_VALUE = exports.ML_PARTITION_FIELD_VALUE = 'partition_field_value';