"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ML_ANOMALY_SEVERITY = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Labels displayed in the ML UI to indicate the severity of the anomaly according
 * to the normalized anomaly score.
 */
let ML_ANOMALY_SEVERITY = exports.ML_ANOMALY_SEVERITY = /*#__PURE__*/function (ML_ANOMALY_SEVERITY) {
  ML_ANOMALY_SEVERITY["CRITICAL"] = "critical";
  ML_ANOMALY_SEVERITY["MAJOR"] = "major";
  ML_ANOMALY_SEVERITY["MINOR"] = "minor";
  ML_ANOMALY_SEVERITY["WARNING"] = "warning";
  ML_ANOMALY_SEVERITY["LOW"] = "low";
  ML_ANOMALY_SEVERITY["UNKNOWN"] = "unknown";
  return ML_ANOMALY_SEVERITY;
}({});
/**
 * Interface for severity types to be used in ML_ANOMALY_SEVERITY_TYPES.
 */