"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getByReferenceState = getByReferenceState;
exports.getByValueState = getByValueState;
exports.initializeLibraryTransforms = initializeLibraryTransforms;
var _kibana_services = require("../kibana_services");
var _content_management = require("../content_management");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getByReferenceState(state, savedObjectId) {
  const {
    attributes,
    ...byRefState
  } = state !== null && state !== void 0 ? state : {};
  return {
    ...byRefState,
    savedObjectId
  };
}
function getByValueState(state, attributes) {
  const {
    savedObjectId,
    ...byValueState
  } = state !== null && state !== void 0 ? state : {};
  return {
    ...byValueState,
    attributes
  };
}
function initializeLibraryTransforms(savedMap, serializeState) {
  return {
    canLinkToLibrary: async () => {
      const {
        maps_v2: maps
      } = (0, _kibana_services.getCore)().application.capabilities;
      return maps.save && savedMap.getSavedObjectId() === undefined;
    },
    saveToLibrary: async title => {
      var _state$rawState$attri, _state$rawState, _state$references;
      const state = serializeState();
      const {
        item: {
          id: savedObjectId
        }
      } = await (0, _content_management.getMapClient)().create({
        data: {
          ...((_state$rawState$attri = (_state$rawState = state.rawState) === null || _state$rawState === void 0 ? void 0 : _state$rawState.attributes) !== null && _state$rawState$attri !== void 0 ? _state$rawState$attri : {}),
          title
        },
        options: {
          references: (_state$references = state.references) !== null && _state$references !== void 0 ? _state$references : []
        }
      });
      return savedObjectId;
    },
    getSerializedStateByReference: libraryId => {
      const {
        rawState: initialRawState,
        references
      } = serializeState();
      const rawState = getByReferenceState(initialRawState, libraryId);
      return {
        rawState,
        references
      };
    },
    checkForDuplicateTitle: async (newTitle, isTitleDuplicateConfirmed, onTitleDuplicate) => {
      await (0, _content_management.checkForDuplicateTitle)({
        title: newTitle,
        copyOnSave: false,
        lastSavedTitle: '',
        isTitleDuplicateConfirmed,
        getDisplayName: () => _constants.MAP_EMBEDDABLE_NAME,
        onTitleDuplicate
      }, {
        overlays: (0, _kibana_services.getCoreOverlays)()
      });
    },
    canUnlinkFromLibrary: async () => {
      return savedMap.getSavedObjectId() !== undefined;
    },
    getSerializedStateByValue: () => {
      const {
        rawState: initialRawState,
        references
      } = serializeState();
      const rawState = getByValueState(initialRawState, savedMap.getAttributes());
      return {
        rawState,
        references
      };
    }
  };
}