"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOCEntryActionsPopover = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _toc_entry_button = require("../toc_entry_button");
var _action_labels = require("../action_labels");
var _es_search_source = require("../../../../../../classes/sources/es_search_source");
var _vector_layer = require("../../../../../../classes/layers/vector_layer");
var _constants = require("../../../../../../../common/constants");
var _remove_layer_confirm_modal = require("../../../../../../components/remove_layer_confirm_modal");
var _layer_group = require("../../../../../../classes/layers/layer_group");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TOCEntryActionsPopover extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false,
      showRemoveModal: false,
      supportsFeatureEditing: false,
      isFeatureEditingEnabled: false
    });
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_closePopover", () => {
      this.setState(() => ({
        isPopoverOpen: false
      }));
    });
  }
  componentDidMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  componentDidUpdate() {
    this._loadFeatureEditing();
  }
  async _loadFeatureEditing() {
    if (!(0, _vector_layer.hasVectorLayerMethod)(this.props.layer, 'supportsFeatureEditing')) {
      return;
    }
    const supportsFeatureEditing = this.props.layer.supportsFeatureEditing();
    const isFeatureEditingEnabled = await this._getIsFeatureEditingEnabled();
    if (!this._isMounted || supportsFeatureEditing === this.state.supportsFeatureEditing && isFeatureEditingEnabled === this.state.isFeatureEditingEnabled) {
      return;
    }
    this.setState({
      supportsFeatureEditing,
      isFeatureEditingEnabled
    });
  }
  async _getIsFeatureEditingEnabled() {
    if (!(0, _vector_layer.hasVectorLayerMethod)(this.props.layer, 'hasJoins')) {
      return false;
    }
    const source = this.props.layer.getSource();
    if (!(source instanceof _es_search_source.ESSearchSource)) {
      return false;
    }
    if (source.getSyncMeta().scalingType === _constants.SCALING_TYPES.CLUSTERS || this.props.layer.isPreviewLayer() || !this.props.layer.isVisible() || this.props.layer.hasJoins()) {
      return false;
    }
    return true;
  }
  _getActionsPanel() {
    const actionItems = [{
      name: _action_labels.FIT_TO_DATA_LABEL,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "expand",
        size: "m"
      }),
      'data-test-subj': 'fitToBoundsButton',
      toolTipContent: this.props.supportsFitToBounds ? null : _i18n.i18n.translate('xpack.maps.layerTocActions.noFitSupportTooltip', {
        defaultMessage: 'Layer does not support fit to data'
      }),
      disabled: !this.props.supportsFitToBounds,
      onClick: () => {
        this._closePopover();
        this.props.fitToBounds(this.props.layer.getId());
      }
    }, {
      name: (0, _action_labels.getVisibilityToggleLabel)(this.props.layer.isVisible()),
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: (0, _action_labels.getVisibilityToggleIcon)(this.props.layer.isVisible()),
        size: "m"
      }),
      'data-test-subj': 'layerVisibilityToggleButton',
      toolTipContent: null,
      onClick: () => {
        this._closePopover();
        this.props.toggleVisible(this.props.layer.getId());
      }
    }];
    if (this.props.numLayers > 2) {
      actionItems.push({
        name: _i18n.i18n.translate('xpack.maps.layerTocActions.showThisLayerOnlyTitle', {
          defaultMessage: 'Show this layer only'
        }),
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "eye",
          size: "m"
        }),
        'data-test-subj': 'showThisLayerOnlyButton',
        toolTipContent: null,
        onClick: () => {
          this._closePopover();
          this.props.showThisLayerOnly(this.props.layer.getId());
        }
      });
    }
    if (!this.props.isReadOnly) {
      actionItems.push({
        disabled: this.props.isEditButtonDisabled,
        name: _action_labels.EDIT_LAYER_SETTINGS_LABEL,
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "pencil",
          size: "m"
        }),
        'data-test-subj': 'layerSettingsButton',
        toolTipContent: null,
        onClick: () => {
          this._closePopover();
          this.props.openLayerSettings();
        }
      });
      if (this.state.supportsFeatureEditing) {
        actionItems.push({
          name: _action_labels.EDIT_FEATURES_LABEL,
          icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "vector",
            size: "m"
          }),
          'data-test-subj': 'editLayerButton',
          toolTipContent: this.state.isFeatureEditingEnabled ? null : _i18n.i18n.translate('xpack.maps.layerTocActions.editFeaturesTooltip.disabledMessage', {
            defaultMessage: 'Edit features is only supported for layers without clustering and term joins'
          }),
          disabled: !this.state.isFeatureEditingEnabled,
          onClick: async () => {
            this._closePopover();
            const supportedShapeTypes = await this.props.layer.getSource().getSupportedShapeTypes();
            const supportsShapes = supportedShapeTypes.includes(_constants.VECTOR_SHAPE_TYPE.POLYGON) && supportedShapeTypes.includes(_constants.VECTOR_SHAPE_TYPE.LINE);
            if (supportsShapes) {
              this.props.enableShapeEditing(this.props.layer.getId());
            } else {
              this.props.enablePointEditing(this.props.layer.getId());
            }
          }
        });
      }
      actionItems.push({
        name: _i18n.i18n.translate('xpack.maps.layerTocActions.cloneLayerTitle', {
          defaultMessage: 'Clone layer'
        }),
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "copy",
          size: "m"
        }),
        toolTipContent: null,
        'data-test-subj': 'cloneLayerButton',
        onClick: () => {
          this._closePopover();
          this.props.cloneLayer(this.props.layer.getId());
        }
      });
      if ((0, _layer_group.isLayerGroup)(this.props.layer) && this.props.layer.getChildren().length > 0) {
        actionItems.push({
          name: _i18n.i18n.translate('xpack.maps.layerTocActions.ungroupLayerTitle', {
            defaultMessage: 'Ungroup layers'
          }),
          icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "layers",
            size: "m"
          }),
          toolTipContent: null,
          'data-test-subj': 'removeLayerButton',
          onClick: () => {
            this._closePopover();
            this.props.ungroupLayer(this.props.layer.getId());
            this.props.removeLayer(this.props.layer.getId());
          }
        });
      }
      actionItems.push({
        name: _i18n.i18n.translate('xpack.maps.layerTocActions.removeLayerTitle', {
          defaultMessage: 'Remove layer'
        }),
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "trash",
          size: "m"
        }),
        toolTipContent: null,
        'data-test-subj': 'removeLayerButton',
        onClick: () => {
          this.setState({
            showRemoveModal: true
          });
        }
      });
    }
    return {
      id: 0,
      title: _i18n.i18n.translate('xpack.maps.layerTocActions.layerActionsTitle', {
        defaultMessage: 'Layer actions'
      }),
      items: actionItems
    };
  }
  render() {
    const removeModal = this.state.showRemoveModal ? /*#__PURE__*/_react.default.createElement(_remove_layer_confirm_modal.RemoveLayerConfirmModal, {
      layer: this.props.layer,
      onCancel: () => {
        this.setState({
          showRemoveModal: false
        });
      },
      onConfirm: () => {
        this.setState({
          showRemoveModal: false
        });
        this._closePopover();
        this.props.removeLayer(this.props.layer.getId());
      }
    }) : null;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, removeModal, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      className: "mapLayTocActions",
      button: /*#__PURE__*/_react.default.createElement(_toc_entry_button.TOCEntryButton, {
        layer: this.props.layer,
        displayName: this.props.displayName,
        escapedDisplayName: this.props.escapedDisplayName,
        onClick: this._togglePopover
      }),
      isOpen: this.state.isPopoverOpen,
      closePopover: this._closePopover,
      panelPaddingSize: "none",
      anchorPosition: "leftUp"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
      initialPanelId: 0,
      panels: [this._getActionsPanel()],
      "data-test-subj": `layerTocActionsPanel${this.props.escapedDisplayName}`
    })));
  }
}
exports.TOCEntryActionsPopover = TOCEntryActionsPopover;