"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppWithoutRouter = exports.App = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _shared_imports = require("../shared_imports");
var _constants = require("../../common/constants");
var _sections = require("./sections");
var _navigation = require("./services/navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AppWithoutRouter = () => {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _navigation.ROUTES.list,
    component: _sections.PipelinesList
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _navigation.ROUTES.clone,
    component: _sections.PipelinesClone
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _navigation.ROUTES.create,
    component: _sections.PipelinesCreate
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _navigation.ROUTES.edit,
    component: _sections.PipelinesEdit
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _navigation.ROUTES.createFromCsv,
    component: _sections.PipelinesCreateFromCsv
  }), services.config.enableManageProcessors && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _navigation.ROUTES.manageProcessors,
    component: _sections.ManageProcessors
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _sections.PipelinesList
  }));
};
exports.AppWithoutRouter = AppWithoutRouter;
const App = () => {
  const {
    apiError
  } = (0, _shared_imports.useAuthorizationContext)();
  const {
    history
  } = (0, _shared_imports.useKibana)().services;
  if (apiError) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.app.checkingPrivilegesErrorMessage",
        defaultMessage: "Error fetching user privileges from the server."
      }),
      error: apiError
    });
  }
  return /*#__PURE__*/_react.default.createElement(_shared_imports.WithPrivileges, {
    privileges: _constants.APP_CLUSTER_REQUIRED_PRIVILEGES.map(privilege => `cluster.${privilege}`)
  }, ({
    isLoading,
    hasPrivileges,
    privilegesMissing
  }) => {
    if (isLoading) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.app.checkingPrivilegesDescription",
        defaultMessage: "Checking privileges\u2026"
      }));
    }
    if (!hasPrivileges) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
        iconType: "securityApp",
        title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ingestPipelines.app.deniedPrivilegeTitle",
          defaultMessage: "Cluster privileges required"
        })),
        body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ingestPipelines.app.deniedPrivilegeDescription",
          defaultMessage: "To use Ingest Pipelines, you must have {privilegesCount, plural, one {this cluster privilege} other {these cluster privileges}}: {missingPrivileges}.",
          values: {
            missingPrivileges: privilegesMissing.cluster.join(', '),
            privilegesCount: privilegesMissing.cluster.length
          }
        }))
      });
    }
    return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
      history: history
    }, /*#__PURE__*/_react.default.createElement(AppWithoutRouter, null));
  });
};
exports.App = App;