"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveIdFormats = resolveIdFormats;
var _log_analysis = require("../../../common/log_analysis");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function resolveIdFormats(spaceId, logViewId, mlAnomalyDetectors) {
  const entryRateFormat = await resolveIdFormat(spaceId, logViewId, _log_analysis.logEntryRateJobType, mlAnomalyDetectors);
  const entryCategoriesCountFormat = await resolveIdFormat(spaceId, logViewId, _log_analysis.logEntryCategoriesJobType, mlAnomalyDetectors);
  return {
    [_log_analysis.logEntryRateJobType]: entryRateFormat,
    [_log_analysis.logEntryCategoriesJobType]: entryCategoriesCountFormat
  };
}
async function resolveIdFormat(spaceId, logViewId, jobType, mlAnomalyDetectors) {
  try {
    const hashedJobId = (0, _log_analysis.getJobId)(spaceId, logViewId, 'hashed', jobType);
    const hashedJobs = await mlAnomalyDetectors.jobs(hashedJobId);
    if (hashedJobs.count > 0) {
      return 'hashed';
    }
  } catch (e) {
    // Ignore 404 in case the job isn't found
    if (e.statusCode !== 404) {
      throw e;
    }
  }
  try {
    const legacyJobId = (0, _log_analysis.getJobId)(spaceId, logViewId, 'legacy', jobType);
    const legacyJobs = await mlAnomalyDetectors.jobs(legacyJobId);
    if (legacyJobs.count > 0) {
      return 'legacy';
    }
  } catch (e) {
    // Ignore 404 in case the job isn't found
    if (e.statusCode !== 404) {
      throw e;
    }
  }
  return 'hashed';
}