"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStepFromQueryString = useStepFromQueryString;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useStepFromQueryString(history) {
  const activeStep = (0, _react.useMemo)(() => {
    const params = new URLSearchParams(history.location.search);
    if (params.has('step')) {
      return params.get('step');
    }
  }, [history.location.search]);
  const updateStep = (0, _react.useCallback)(stepId => {
    const params = new URLSearchParams(history.location.search);
    if (params.has('step')) {
      params.set('step', stepId);
      history.push({
        search: params.toString()
      });
    }
  }, [history]);
  return {
    activeStep,
    updateStep
  };
}