"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateAdditionalDatastreamsPermissionsForSpace = validateAdditionalDatastreamsPermissionsForSpace;
exports.validatePackagePoliciesUniqueNameAcrossSpaces = validatePackagePoliciesUniqueNameAcrossSpaces;
exports.validatePolicyNamespaceForSpace = validatePolicyNamespaceForSpace;
var _pMap = _interopRequireDefault(require("p-map"));
var _app_context = require("../app_context");
var _errors = require("../../../common/errors");
var _package_policy = require("../package_policy");
var _constants = require("../../constants");
var _errors2 = require("../../errors");
var _space_settings = require("./space_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function validatePolicyNamespaceForSpace({
  namespace,
  spaceId
}) {
  const experimentalFeature = _app_context.appContextService.getExperimentalFeatures();
  if (!experimentalFeature.useSpaceAwareness) {
    return;
  }
  const settings = await (0, _space_settings.getSpaceSettings)(spaceId);
  if (!settings.allowed_namespace_prefixes || settings.allowed_namespace_prefixes.length === 0) {
    return;
  }
  let valid = false;
  for (const allowedNamespacePrefix of settings.allowed_namespace_prefixes) {
    if (namespace.startsWith(allowedNamespacePrefix)) {
      valid = true;
      break;
    }
  }
  if (!valid) {
    throw new _errors.PolicyNamespaceValidationError(`Invalid namespace, supported namespace prefixes: ${settings.allowed_namespace_prefixes.join(', ')}`);
  }
}
async function validateAdditionalDatastreamsPermissionsForSpace({
  additionalDatastreamsPermissions,
  spaceId
}) {
  const experimentalFeature = _app_context.appContextService.getExperimentalFeatures();
  if (!experimentalFeature.useSpaceAwareness) {
    return;
  }
  const settings = await (0, _space_settings.getSpaceSettings)(spaceId);
  if (!settings.allowed_namespace_prefixes || settings.allowed_namespace_prefixes.length === 0 || !additionalDatastreamsPermissions || !additionalDatastreamsPermissions.length) {
    return;
  }
  for (const additionalDatastreamsPermission of additionalDatastreamsPermissions) {
    let valid = false;
    for (const allowedNamespacePrefix of settings.allowed_namespace_prefixes) {
      if (additionalDatastreamsPermission.startsWith(allowedNamespacePrefix)) {
        valid = true;
        break;
      }
    }
    if (!valid) {
      throw new _errors.PolicyNamespaceValidationError(`Invalid additionalDatastreamsPermission, supported namespace prefixes: ${settings.allowed_namespace_prefixes.join(', ')}`);
    }
  }
}
async function validatePackagePoliciesUniqueNameAcrossSpaces(packagePolicies, newSpaceIds = []) {
  if (packagePolicies === undefined || packagePolicies.length === 0) return;
  const allSpacesSoClient = _app_context.appContextService.getInternalUserSOClientWithoutSpaceExtension();
  await (0, _pMap.default)(packagePolicies, async pkgPolicy => {
    const {
      items
    } = await _package_policy.packagePolicyService.list(allSpacesSoClient, {
      kuery: `${_constants.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.name:"${pkgPolicy.name}"`,
      spaceId: '*'
    });
    const filteredItems = items.filter(item => item.id !== pkgPolicy.id);
    const matchingSpaceId = newSpaceIds.find(spaceId => filteredItems.flatMap(item => {
      var _item$spaceIds;
      return (_item$spaceIds = item.spaceIds) !== null && _item$spaceIds !== void 0 ? _item$spaceIds : [];
    }).includes(spaceId));
    if (matchingSpaceId) throw new _errors2.PackagePolicyNameExistsError(`An integration policy with the name ${pkgPolicy.name} already exists in space "${matchingSpaceId}". Please rename it or choose a different name.`);
  }, {
    concurrency: _constants.MAX_CONCURRENT_AGENT_POLICIES_OPERATIONS_20
  });
}