"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateIndexSettings = updateIndexSettings;
var _ = require("../../..");
var _retry = require("../retry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function updateIndexSettings(esClient, index, settings) {
  const logger = _.appContextService.getLogger();
  if (index) {
    try {
      await (0, _retry.retryTransientEsErrors)(() => esClient.indices.putSettings({
        index,
        settings
      }));
    } catch (err) {
      // No need to throw error and block installation process
      logger.debug(`Could not update index settings for ${index} because ${err}`);
    }
  }
}