"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.databaseSearchGuideId = exports.databaseSearchGuideConfig = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const databaseSearchGuideId = exports.databaseSearchGuideId = 'databaseSearch';
const apiRoutes = {
  [databaseSearchGuideId]: '/connectors/select_connector'
};
const getAddDataStep = method => {
  return {
    id: 'add_data',
    title: _i18n.i18n.translate('xpack.enterpriseSearch.guideConfig.addDataStep.title', {
      defaultMessage: 'Add data'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.guideConfig.addDataStep.description', {
      defaultMessage: 'Ingest your data, create an index, and enrich your data with customizable ingest and inference pipelines.'
    }),
    location: {
      appID: 'enterpriseSearchContent',
      path: `${method ? apiRoutes[method] : '/search_indices/new_index'}`
    }
  };
};
const getSearchExperienceStep = () => {
  return {
    id: 'search_experience',
    title: _i18n.i18n.translate('xpack.enterpriseSearch.guideConfig.searchExperienceStep.title', {
      defaultMessage: 'Build a search experience'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.guideConfig.searchExperienceStep.description', {
      defaultMessage: `Learn more about Elastic's Search UI, try our Search UI tutorial for Elasticsearch, and build a search experience.`
    }),
    location: {
      appID: 'searchExperiences',
      path: ''
    },
    manualCompletion: {
      title: _i18n.i18n.translate('xpack.enterpriseSearch.guideConfig.searchExperienceStep.manualCompletionPopoverTitle', {
        defaultMessage: 'Explore Search UI'
      }),
      description: _i18n.i18n.translate('xpack.enterpriseSearch.guideConfig.searchExperienceStep.manualCompletionPopoverDescription', {
        defaultMessage: `Take your time to explore how to use Search UI to build world-class search experiences. When you're ready, click the Setup guide button to continue.`
      }),
      readyToCompleteOnNavigation: true
    }
  };
};
const getGuideConfig = telemetryId => {
  return {
    telemetryId,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.guideConfig.title', {
      defaultMessage: 'Build search experiences with Elasticsearch'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.guideConfig.description', {
      defaultMessage: `We'll help you build a search experience with your data using Elastic's web crawler, connectors, and APIs.`
    }),
    guideName: 'Enterprise Search',
    steps: [getAddDataStep(telemetryId), getSearchExperienceStep()]
  };
};
const databaseSearchGuideConfig = exports.databaseSearchGuideConfig = getGuideConfig(databaseSearchGuideId);