"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAttackDiscoveryScheduleType = void 0;
var _server = require("@kbn/core/server");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _server2 = require("@kbn/task-manager-plugin/server");
var _constants = require("../constants");
var _executor = require("./executor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAttackDiscoveryScheduleType = ({
  logger,
  publicBaseUrl,
  telemetry
}) => {
  return {
    id: _elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_ALERT_TYPE_ID,
    name: 'Attack Discovery Schedule',
    ruleTaskTimeout: '10m',
    actionGroups: [{
      id: 'default',
      name: 'Default'
    }],
    defaultActionGroupId: 'default',
    category: _server.DEFAULT_APP_CATEGORIES.security.id,
    producer: 'siem',
    solution: 'security',
    priority: _server2.TaskPriority.NormalLongRunning,
    validate: {
      params: {
        validate: object => {
          return _elasticAssistantCommon.AttackDiscoveryScheduleParams.parse(object);
        }
      }
    },
    schemas: {
      params: {
        type: 'zod',
        schema: _elasticAssistantCommon.AttackDiscoveryScheduleParams
      }
    },
    actionVariables: {
      context: [{
        name: 'server',
        description: 'the server'
      }]
    },
    minimumLicenseRequired: 'basic',
    isExportable: false,
    autoRecoverAlerts: false,
    alerts: _constants.ATTACK_DISCOVERY_ALERTS_AAD_CONFIG,
    executor: async options => {
      return (0, _executor.attackDiscoveryScheduleExecutor)({
        options,
        logger,
        publicBaseUrl,
        telemetry
      });
    }
  };
};
exports.getAttackDiscoveryScheduleType = getAttackDiscoveryScheduleType;