"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChromeService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _rxjs = require("rxjs");
var _url = require("url");
var _eui = require("@elastic/eui");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _coreMountUtilsBrowserInternal = require("@kbn/core-mount-utils-browser-internal");
var _recentlyAccessed = require("@kbn/recently-accessed");
var _printing_observable = require("./utils/printing_observable");
var _doc_title = require("./doc_title");
var _nav_controls = require("./nav_controls");
var _nav_links = require("./nav_links");
var _project_navigation = require("./project_navigation");
var _ui = require("./ui");
var _register_analytics_context_provider = require("./register_analytics_context_provider");
var _header_top_banner = require("./ui/header/header_top_banner");
var _handle_system_colormode_change = require("./handle_system_colormode_change");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const IS_LOCKED_KEY = 'core.chrome.isLocked';
const IS_SIDENAV_COLLAPSED_KEY = 'core.chrome.isSideNavCollapsed';
const SNAPSHOT_REGEX = /-snapshot/i;
/** @internal */
class ChromeService {
  constructor(params) {
    (0, _defineProperty2.default)(this, "isVisible$", void 0);
    (0, _defineProperty2.default)(this, "isForceHidden$", void 0);
    (0, _defineProperty2.default)(this, "stop$", new _rxjs.ReplaySubject(1));
    (0, _defineProperty2.default)(this, "navControls", new _nav_controls.NavControlsService());
    (0, _defineProperty2.default)(this, "navLinks", new _nav_links.NavLinksService());
    (0, _defineProperty2.default)(this, "recentlyAccessed", new _recentlyAccessed.RecentlyAccessedService());
    (0, _defineProperty2.default)(this, "docTitle", new _doc_title.DocTitleService());
    (0, _defineProperty2.default)(this, "projectNavigation", void 0);
    (0, _defineProperty2.default)(this, "mutationObserver", void 0);
    (0, _defineProperty2.default)(this, "isSideNavCollapsed$", new _rxjs.BehaviorSubject(localStorage.getItem(IS_SIDENAV_COLLAPSED_KEY) === 'true'));
    (0, _defineProperty2.default)(this, "isFeedbackBtnVisible$", new _rxjs.BehaviorSubject(false));
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "isServerless", false);
    (0, _defineProperty2.default)(this, "setIsVisible", isVisible => this.isForceHidden$.next(!isVisible));
    /**
     * Some EUI component can be toggled in Full screen (e.g. the EuiDataGrid). When they are toggled in full
     * screen we want to hide the chrome, and when they are toggled back to normal we want to show the chrome.
     */
    (0, _defineProperty2.default)(this, "handleEuiFullScreenChanges", () => {
      const {
        body
      } = document;
      // HTML class names that are added to the body when Eui components are toggled in full screen
      const classesOnBodyWhenEuiFullScreen = ['euiDataGrid__restrictBody'];
      let isChromeHiddenForEuiFullScreen = false;
      let isChromeVisible = false;
      this.isVisible$.pipe((0, _rxjs.takeUntil)(this.stop$)).subscribe(isVisible => {
        isChromeVisible = isVisible;
      });
      const onBodyClassesChange = () => {
        const {
          className
        } = body;
        if (classesOnBodyWhenEuiFullScreen.some(name => className.includes(name)) && isChromeVisible) {
          isChromeHiddenForEuiFullScreen = true;
          this.setIsVisible(false);
        } else if (classesOnBodyWhenEuiFullScreen.every(name => !className.includes(name)) && !isChromeVisible && isChromeHiddenForEuiFullScreen) {
          isChromeHiddenForEuiFullScreen = false;
          this.setIsVisible(true);
        }
      };
      this.mutationObserver = new MutationObserver(mutationList => {
        mutationList.forEach(mutation => {
          if (mutation.type === 'attributes' && mutation.attributeName === 'class') {
            onBodyClassesChange();
          }
        });
      });
      this.mutationObserver.observe(body, {
        attributes: true
      });
    });
    // Ensure developers are notified if working in a context that lacks the EUI Provider.
    // @ts-expect-error
    (0, _defineProperty2.default)(this, "handleEuiDevProviderWarning", notifications => {
      const isDev = this.params.coreContext.env.mode.name === 'development';
      if (isDev) {
        (0, _eui.setEuiDevProviderWarning)(providerError => {
          var _errorObject$stack;
          const errorObject = new Error(providerError.toString());
          // 1. show a stack trace in the console
          // eslint-disable-next-line no-console
          console.error(errorObject);

          // 2. store error in sessionStorage so it can be detected in testing
          const storedError = {
            message: providerError.toString(),
            stack: (_errorObject$stack = errorObject.stack) !== null && _errorObject$stack !== void 0 ? _errorObject$stack : 'undefined',
            pageHref: window.location.href,
            pageTitle: document.title
          };
          sessionStorage.setItem('dev.euiProviderWarning', JSON.stringify(storedError));

          // 3. error toast / popup
          notifications.toasts.addDanger({
            title: '`EuiProvider` is missing',
            text: (0, _coreMountUtilsBrowserInternal.mountReactNode)(/*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "core.chrome.euiDevProviderWarning",
              defaultMessage: "Kibana components must be wrapped in a React Context provider for full functionality and proper theming support. See {link}.",
              values: {
                link: /*#__PURE__*/_react.default.createElement("a", {
                  href: "https://docs.elastic.dev/kibana-dev-docs/react-context"
                }, "https://docs.elastic.dev/kibana-dev-docs/react-context")
              }
            }))),
            'data-test-subj': 'core-chrome-euiDevProviderWarning-toast',
            toastLifeTimeMs: 60 * 60 * 1000 // keep message visible for up to an hour
          });
        });
      }
    });
    this.params = params;
    this.logger = params.coreContext.logger.get('chrome-browser');
    this.isServerless = params.coreContext.env.packageInfo.buildFlavor === 'serverless';
    this.projectNavigation = new _project_navigation.ProjectNavigationService(this.isServerless);
  }

  /**
   * These observables allow consumers to toggle the chrome visibility via either:
   *   1. Using setIsVisible() to trigger the next chromeHidden$
   *   2. Setting `chromeless` when registering an application, which will
   *      reset the visibility whenever the next application is mounted
   *   3. Having "embed" in the query string
   */
  initVisibility(application) {
    // Start off the chrome service hidden if "embed" is in the hash query string.
    const isEmbedded = 'embed' in (0, _url.parse)(location.hash.slice(1), true).query;
    this.isForceHidden$ = new _rxjs.BehaviorSubject(isEmbedded);
    const appHidden$ = (0, _rxjs.merge)(
    // For the isVisible$ logic, having no mounted app is equivalent to having a hidden app
    // in the sense that the chrome UI should not be displayed until a non-chromeless app is mounting or mounted
    (0, _rxjs.of)(true), application.currentAppId$.pipe((0, _rxjs.mergeMap)(appId => application.applications$.pipe((0, _rxjs.map)(applications => {
      return !!appId && applications.has(appId) && !!applications.get(appId).chromeless;
    })))));
    this.isVisible$ = (0, _rxjs.combineLatest)([appHidden$, this.isForceHidden$, _printing_observable.isPrinting$]).pipe((0, _rxjs.map)(([appHidden, forceHidden, isPrinting]) => !appHidden && !forceHidden && !isPrinting), (0, _rxjs.takeUntil)(this.stop$));
  }
  setup({
    analytics
  }) {
    const docTitle = this.docTitle.setup({
      document: window.document
    });
    (0, _register_analytics_context_provider.registerAnalyticsContextProvider)(analytics, docTitle.title$);
  }
  async start({
    application,
    docLinks,
    http,
    injectedMetadata,
    notifications,
    customBranding,
    i18n: i18nService,
    theme,
    userProfile,
    uiSettings
  }) {
    this.initVisibility(application);
    this.handleEuiFullScreenChanges();
    (0, _handle_system_colormode_change.handleSystemColorModeChange)({
      notifications,
      coreStart: {
        i18n: i18nService,
        theme,
        userProfile
      },
      stop$: this.stop$,
      http,
      uiSettings
    });
    // commented out until https://github.com/elastic/kibana/issues/201805 can be fixed
    // this.handleEuiDevProviderWarning(notifications);

    const globalHelpExtensionMenuLinks$ = new _rxjs.BehaviorSubject([]);
    const helpExtension$ = new _rxjs.BehaviorSubject(undefined);
    const breadcrumbs$ = new _rxjs.BehaviorSubject([]);
    const breadcrumbsAppendExtensions$ = new _rxjs.BehaviorSubject([]);
    const badge$ = new _rxjs.BehaviorSubject(undefined);
    const customNavLink$ = new _rxjs.BehaviorSubject(undefined);
    const helpSupportUrl$ = new _rxjs.BehaviorSubject(docLinks.links.kibana.askElastic);
    const isNavDrawerLocked$ = new _rxjs.BehaviorSubject(localStorage.getItem(IS_LOCKED_KEY) === 'true');
    // ChromeStyle is set to undefined by default, which means that no header will be rendered until
    // setChromeStyle(). This is to avoid a flickering between the "classic" and "project" header meanwhile
    // we load the user profile to check if the user opted out of the new solution navigation.
    const chromeStyleSubject$ = new _rxjs.BehaviorSubject(undefined);
    const getKbnVersionClass = () => {
      // we assume that the version is valid and has the form 'X.X.X'
      // strip out `SNAPSHOT` and reformat to 'X-X-X'
      const formattedVersionClass = this.params.kibanaVersion.replace(SNAPSHOT_REGEX, '').split('.').join('-');
      return `kbnVersion-${formattedVersionClass}`;
    };
    const chromeStyle$ = chromeStyleSubject$.pipe((0, _rxjs.filter)(style => style !== undefined), (0, _rxjs.takeUntil)(this.stop$));
    const setChromeStyle = style => {
      if (style === chromeStyleSubject$.getValue()) return;
      chromeStyleSubject$.next(style);
    };
    const headerBanner$ = new _rxjs.BehaviorSubject(undefined);
    const bodyClasses$ = (0, _rxjs.combineLatest)([headerBanner$, this.isVisible$, chromeStyleSubject$, application.currentActionMenu$]).pipe((0, _rxjs.map)(([headerBanner, isVisible, chromeStyle, actionMenu]) => {
      return ['kbnBody', headerBanner ? 'kbnBody--hasHeaderBanner' : 'kbnBody--noHeaderBanner', isVisible ? 'kbnBody--chromeVisible' : 'kbnBody--chromeHidden', chromeStyle === 'project' && actionMenu ? 'kbnBody--hasProjectActionMenu' : '', getKbnVersionClass()].filter(className => !!className);
    }));
    const navControls = this.navControls.start();
    const navLinks = this.navLinks.start({
      application,
      http
    });
    const projectNavigation = this.projectNavigation.start({
      application,
      navLinksService: navLinks,
      http,
      chromeBreadcrumbs$: breadcrumbs$,
      logger: this.logger
    });
    const recentlyAccessed = this.recentlyAccessed.start({
      http,
      key: 'recentlyAccessed'
    });
    const docTitle = this.docTitle.start();
    const {
      customBranding$
    } = customBranding;
    const helpMenuLinks$ = navControls.getHelpMenuLinks$();

    // erase chrome fields from a previous app while switching to a next app
    application.currentAppId$.subscribe(() => {
      helpExtension$.next(undefined);
      breadcrumbs$.next([]);
      badge$.next(undefined);
      docTitle.reset();
    });
    const setIsNavDrawerLocked = isLocked => {
      isNavDrawerLocked$.next(isLocked);
      localStorage.setItem(IS_LOCKED_KEY, `${isLocked}`);
    };
    const getIsNavDrawerLocked$ = isNavDrawerLocked$.pipe((0, _rxjs.takeUntil)(this.stop$));
    const validateChromeStyle = () => {
      const chromeStyle = chromeStyleSubject$.getValue();
      if (chromeStyle !== 'project') {
        // Helps ensure callers go through the serverless plugin to get here.
        throw new Error(`Invalid ChromeStyle value of "${chromeStyle}". This method requires ChromeStyle set to "project".`);
      }
    };
    const setProjectSideNavComponent = component => {
      validateChromeStyle();
      projectNavigation.setSideNavComponent(component);
    };
    function initProjectNavigation(id, navigationTree$) {
      validateChromeStyle();
      projectNavigation.initNavigation(id, navigationTree$);
    }
    const setProjectBreadcrumbs = (breadcrumbs, params) => {
      projectNavigation.setProjectBreadcrumbs(breadcrumbs, params);
    };
    const setClassicBreadcrumbs = (newBreadcrumbs, {
      project
    } = {}) => {
      breadcrumbs$.next(newBreadcrumbs);
      if (project) {
        const {
          value: projectValue,
          absolute = false
        } = project;
        setProjectBreadcrumbs(projectValue !== null && projectValue !== void 0 ? projectValue : [], {
          absolute
        });
      }
    };
    const setProjectHome = homeHref => {
      validateChromeStyle();
      projectNavigation.setProjectHome(homeHref);
    };
    const setProjectName = projectName => {
      validateChromeStyle();
      projectNavigation.setProjectName(projectName);
    };
    const setIsSideNavCollapsed = isCollapsed => {
      localStorage.setItem(IS_SIDENAV_COLLAPSED_KEY, JSON.stringify(isCollapsed));
      this.isSideNavCollapsed$.next(isCollapsed);
    };
    if (!this.params.browserSupportsCsp && injectedMetadata.getCspConfig().warnLegacyBrowsers) {
      notifications.toasts.addWarning({
        title: (0, _coreMountUtilsBrowserInternal.mountReactNode)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "core.chrome.legacyBrowserWarning",
          defaultMessage: "Your browser does not meet the security requirements for Kibana."
        }))
      });
    }
    const getHeaderComponent = () => {
      const defaultChromeStyle = chromeStyleSubject$.getValue();
      const HeaderComponent = () => {
        const isVisible = (0, _useObservable.default)(this.isVisible$);
        const chromeStyle = (0, _useObservable.default)(chromeStyle$, defaultChromeStyle);
        if (!isVisible) {
          return /*#__PURE__*/_react.default.createElement("div", {
            "data-test-subj": "kibanaHeaderChromeless"
          }, /*#__PURE__*/_react.default.createElement(_ui.LoadingIndicator, {
            loadingCount$: http.getLoadingCount$(),
            showAsBar: true
          }), /*#__PURE__*/_react.default.createElement(_header_top_banner.HeaderTopBanner, {
            headerBanner$: headerBanner$.pipe((0, _rxjs.takeUntil)(this.stop$))
          }));
        }
        if (chromeStyle === undefined) return null;

        // render header
        if (chromeStyle === 'project') {
          const projectNavigationComponent$ = projectNavigation.getProjectSideNavComponent$();
          const projectBreadcrumbs$ = projectNavigation.getProjectBreadcrumbs$().pipe((0, _rxjs.takeUntil)(this.stop$));
          const activeNodes$ = projectNavigation.getActiveNodes$();
          const ProjectHeaderWithNavigationComponent = () => {
            const CustomSideNavComponent = (0, _useObservable.default)(projectNavigationComponent$, {
              current: null
            });
            const activeNodes = (0, _useObservable.default)(activeNodes$, []);
            const currentProjectBreadcrumbs$ = projectBreadcrumbs$;
            const SideNavComponent = (0, _react.useMemo)(() => {
              if (CustomSideNavComponent.current) {
                return CustomSideNavComponent.current;
              }
              return () => null;
            }, [CustomSideNavComponent]);
            return /*#__PURE__*/_react.default.createElement(_ui.ProjectHeader, {
              isServerless: this.isServerless,
              application: application,
              globalHelpExtensionMenuLinks$: globalHelpExtensionMenuLinks$,
              actionMenu$: application.currentActionMenu$,
              breadcrumbs$: currentProjectBreadcrumbs$,
              breadcrumbsAppendExtensions$: breadcrumbsAppendExtensions$.pipe((0, _rxjs.takeUntil)(this.stop$)),
              customBranding$: customBranding$,
              helpExtension$: helpExtension$.pipe((0, _rxjs.takeUntil)(this.stop$)),
              helpSupportUrl$: helpSupportUrl$.pipe((0, _rxjs.takeUntil)(this.stop$)),
              helpMenuLinks$: helpMenuLinks$,
              navControlsLeft$: navControls.getLeft$(),
              navControlsCenter$: navControls.getCenter$(),
              navControlsRight$: navControls.getRight$(),
              loadingCount$: http.getLoadingCount$(),
              headerBanner$: headerBanner$.pipe((0, _rxjs.takeUntil)(this.stop$)),
              homeHref$: projectNavigation.getProjectHome$(),
              docLinks: docLinks,
              kibanaVersion: injectedMetadata.getKibanaVersion(),
              prependBasePath: http.basePath.prepend,
              isSideNavCollapsed$: this.isSideNavCollapsed$,
              toggleSideNav: setIsSideNavCollapsed
            }, /*#__PURE__*/_react.default.createElement(SideNavComponent, {
              activeNodes: activeNodes
            }));
          };
          return /*#__PURE__*/_react.default.createElement(ProjectHeaderWithNavigationComponent, null);
        }
        return /*#__PURE__*/_react.default.createElement(_ui.Header, {
          isServerless: this.isServerless,
          loadingCount$: http.getLoadingCount$(),
          application: application,
          headerBanner$: headerBanner$.pipe((0, _rxjs.takeUntil)(this.stop$)),
          badge$: badge$.pipe((0, _rxjs.takeUntil)(this.stop$)),
          basePath: http.basePath,
          breadcrumbs$: breadcrumbs$.pipe((0, _rxjs.takeUntil)(this.stop$)),
          breadcrumbsAppendExtensions$: breadcrumbsAppendExtensions$.pipe((0, _rxjs.takeUntil)(this.stop$)),
          customNavLink$: customNavLink$.pipe((0, _rxjs.takeUntil)(this.stop$)),
          kibanaDocLink: docLinks.links.kibana.guide,
          docLinks: docLinks,
          forceAppSwitcherNavigation$: navLinks.getForceAppSwitcherNavigation$(),
          globalHelpExtensionMenuLinks$: globalHelpExtensionMenuLinks$,
          helpExtension$: helpExtension$.pipe((0, _rxjs.takeUntil)(this.stop$)),
          helpSupportUrl$: helpSupportUrl$.pipe((0, _rxjs.takeUntil)(this.stop$)),
          helpMenuLinks$: helpMenuLinks$,
          homeHref: http.basePath.prepend('/app/home'),
          kibanaVersion: injectedMetadata.getKibanaVersion(),
          navLinks$: navLinks.getNavLinks$(),
          recentlyAccessed$: recentlyAccessed.get$(),
          navControlsLeft$: navControls.getLeft$(),
          navControlsCenter$: navControls.getCenter$(),
          navControlsRight$: navControls.getRight$(),
          navControlsExtension$: navControls.getExtension$(),
          onIsLockedUpdate: setIsNavDrawerLocked,
          isLocked$: getIsNavDrawerLocked$,
          customBranding$: customBranding$
        });
      };
      return /*#__PURE__*/_react.default.createElement(HeaderComponent, null);
    };
    return {
      navControls,
      navLinks,
      recentlyAccessed,
      docTitle,
      getHeaderComponent,
      getIsVisible$: () => this.isVisible$,
      setIsVisible: this.setIsVisible.bind(this),
      getBadge$: () => badge$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      setBadge: badge => {
        badge$.next(badge);
      },
      getBreadcrumbs$: () => breadcrumbs$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      setBreadcrumbs: setClassicBreadcrumbs,
      getBreadcrumbsAppendExtensions$: () => breadcrumbsAppendExtensions$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      setBreadcrumbsAppendExtension: breadcrumbsAppendExtension => {
        breadcrumbsAppendExtensions$.next([...breadcrumbsAppendExtensions$.getValue(), breadcrumbsAppendExtension].sort(({
          order: orderA = 50
        }, {
          order: orderB = 50
        }) => orderA - orderB));
        return () => {
          breadcrumbsAppendExtensions$.next(breadcrumbsAppendExtensions$.getValue().filter(ext => ext !== breadcrumbsAppendExtension));
        };
      },
      getGlobalHelpExtensionMenuLinks$: () => globalHelpExtensionMenuLinks$.asObservable(),
      registerGlobalHelpExtensionMenuLink: globalHelpExtensionMenuLink => {
        globalHelpExtensionMenuLinks$.next([...globalHelpExtensionMenuLinks$.value, globalHelpExtensionMenuLink]);
      },
      getHelpExtension$: () => helpExtension$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      setHelpExtension: helpExtension => {
        helpExtension$.next(helpExtension);
      },
      setHelpSupportUrl: url => helpSupportUrl$.next(url),
      getHelpSupportUrl$: () => helpSupportUrl$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      getIsNavDrawerLocked$: () => getIsNavDrawerLocked$,
      getCustomNavLink$: () => customNavLink$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      setCustomNavLink: customNavLink => {
        customNavLink$.next(customNavLink);
      },
      setHelpMenuLinks: helpMenuLinks => {
        navControls.setHelpMenuLinks(helpMenuLinks);
      },
      setHeaderBanner: headerBanner => {
        headerBanner$.next(headerBanner);
      },
      hasHeaderBanner$: () => {
        return headerBanner$.pipe((0, _rxjs.takeUntil)(this.stop$), (0, _rxjs.map)(banner => Boolean(banner)));
      },
      getBodyClasses$: () => bodyClasses$.pipe((0, _rxjs.takeUntil)(this.stop$)),
      setChromeStyle,
      getChromeStyle$: () => chromeStyle$,
      sideNav: {
        getIsCollapsed$: () => this.isSideNavCollapsed$.asObservable(),
        setIsCollapsed: setIsSideNavCollapsed,
        getPanelSelectedNode$: projectNavigation.getPanelSelectedNode$.bind(projectNavigation),
        setPanelSelectedNode: projectNavigation.setPanelSelectedNode.bind(projectNavigation),
        getIsFeedbackBtnVisible$: () => (0, _rxjs.combineLatest)([this.isFeedbackBtnVisible$, this.isSideNavCollapsed$]).pipe((0, _rxjs.map)(([isVisible, isCollapsed]) => isVisible && !isCollapsed)),
        setIsFeedbackBtnVisible: isVisible => this.isFeedbackBtnVisible$.next(isVisible)
      },
      getActiveSolutionNavId$: () => projectNavigation.getActiveSolutionNavId$(),
      project: {
        setHome: setProjectHome,
        setCloudUrls: projectNavigation.setCloudUrls.bind(projectNavigation),
        setProjectName,
        initNavigation: initProjectNavigation,
        getNavigationTreeUi$: () => projectNavigation.getNavigationTreeUi$(),
        setSideNavComponent: setProjectSideNavComponent,
        setBreadcrumbs: setProjectBreadcrumbs,
        getBreadcrumbs$: projectNavigation.getProjectBreadcrumbs$.bind(projectNavigation),
        getActiveNavigationNodes$: () => projectNavigation.getActiveNodes$(),
        updateSolutionNavigations: projectNavigation.updateSolutionNavigations,
        changeActiveSolutionNavigation: projectNavigation.changeActiveSolutionNavigation
      }
    };
  }
  stop() {
    var _this$mutationObserve;
    this.navLinks.stop();
    this.projectNavigation.stop();
    this.stop$.next();
    (_this$mutationObserve = this.mutationObserver) === null || _this$mutationObserve === void 0 ? void 0 : _this$mutationObserve.disconnect();
  }
}
exports.ChromeService = ChromeService;