"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SYNCHRONIZATION_QUERIES_DICTIONARY = exports.CAI_REFRESH_INTERVAL = exports.CAI_NUMBER_OF_SHARDS = exports.CAI_INDEX_MODE = exports.CAI_DEFAULT_TIMEOUT = exports.CAI_AUTO_EXPAND_REPLICAS = void 0;
var _constants = require("./attachments_index/constants");
var _constants2 = require("./cases_index/constants");
var _constants3 = require("./comments_index/constants");
var _constants4 = require("./activity_index/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CAI_NUMBER_OF_SHARDS = exports.CAI_NUMBER_OF_SHARDS = 1;
/** Allocate 1 replica if there are enough data nodes, otherwise continue with 0 */
const CAI_AUTO_EXPAND_REPLICAS = exports.CAI_AUTO_EXPAND_REPLICAS = '0-1';
const CAI_REFRESH_INTERVAL = exports.CAI_REFRESH_INTERVAL = '15s';
const CAI_INDEX_MODE = exports.CAI_INDEX_MODE = 'lookup';
/**
 * When a request takes a long time to complete and hits the timeout or the
 * client aborts that request due to the requestTimeout, our only course of
 * action is to retry that request. This places our request at the end of the
 * queue and adds more load to Elasticsearch just making things worse.
 *
 * So we want to choose as long a timeout as possible. Some load balancers /
 * reverse proxies like ELB ignore TCP keep-alive packets so unless there's a
 * request or response sent over the socket it will be dropped after 60s.
 */
const CAI_DEFAULT_TIMEOUT = exports.CAI_DEFAULT_TIMEOUT = '300s';
const SYNCHRONIZATION_QUERIES_DICTIONARY = exports.SYNCHRONIZATION_QUERIES_DICTIONARY = {
  [_constants2.CAI_CASES_INDEX_NAME]: _constants2.getCasesSynchronizationSourceQuery,
  [_constants3.CAI_COMMENTS_INDEX_NAME]: _constants3.getCommentsSynchronizationSourceQuery,
  [_constants.CAI_ATTACHMENTS_INDEX_NAME]: _constants.getAttachmentsSynchronizationSourceQuery,
  [_constants4.CAI_ACTIVITY_INDEX_NAME]: _constants4.getActivitySynchronizationSourceQuery
};