"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggestUserProfiles = exports.getCurrentUserProfile = exports.bulkGetUserProfiles = void 0;
var _lodash = require("lodash");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const suggestUserProfiles = async ({
  http,
  name,
  size = _constants.DEFAULT_USER_SIZE,
  owners,
  signal
}) => {
  const response = await http.post(_constants.INTERNAL_SUGGEST_USER_PROFILES_URL, {
    body: JSON.stringify({
      name,
      size,
      owners
    }),
    signal
  });
  return response;
};
exports.suggestUserProfiles = suggestUserProfiles;
const bulkGetUserProfiles = async ({
  security,
  uids
}) => {
  const cleanUids = uids.filter(uid => !(0, _lodash.isEmpty)(uid));
  if (cleanUids.length === 0) {
    return [];
  }
  return security.userProfiles.bulkGet({
    uids: new Set(cleanUids),
    dataPath: 'avatar'
  });
};
exports.bulkGetUserProfiles = bulkGetUserProfiles;
const getCurrentUserProfile = async ({
  security
}) => {
  return security.userProfiles.getCurrent({
    dataPath: 'avatar'
  });
};
exports.getCurrentUserProfile = getCurrentUserProfile;