"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuccessSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_kibana = require("../../hooks/use_kibana");
var _section_wrapper = require("../section_wrapper");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SuccessSection = exports.SuccessSection = /*#__PURE__*/_react.default.memo(({
  integrationName,
  children
}) => {
  var _useKibana$services$a;
  const getUrlForApp = (_useKibana$services$a = (0, _use_kibana.useKibana)().services.application) === null || _useKibana$services$a === void 0 ? void 0 : _useKibana$services$a.getUrlForApp;
  const {
    installIntegrationUrl,
    viewIntegrationUrl
  } = (0, _react.useMemo)(() => {
    if (!getUrlForApp) {
      return {
        installIntegrationUrl: '',
        viewIntegrationUrl: ''
      };
    }
    return {
      installIntegrationUrl: getUrlForApp === null || getUrlForApp === void 0 ? void 0 : getUrlForApp('fleet', {
        path: `/integrations/${integrationName}/add-integration`
      }),
      viewIntegrationUrl: getUrlForApp === null || getUrlForApp === void 0 ? void 0 : getUrlForApp('integrations', {
        path: `/detail/${integrationName}`
      })
    };
  }, [integrationName, getUrlForApp]);
  return /*#__PURE__*/_react.default.createElement(_section_wrapper.SectionWrapper, {
    title: i18n.SUCCESS_TITLE,
    subtitle: i18n.SUCCESS_DESCRIPTION
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l",
    alignItems: "center",
    justifyContent: "center",
    "data-test-subj": "integrationSuccessSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    paddingSize: "l",
    titleSize: "xs",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "launch",
      size: "l"
    }),
    title: i18n.ADD_TO_AGENT_TITLE,
    description: i18n.ADD_TO_AGENT_DESCRIPTION,
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: installIntegrationUrl
    }, i18n.ADD_TO_AGENT_BUTTON)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    paddingSize: "l",
    titleSize: "xs",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "eye",
      size: "l"
    }),
    title: i18n.VIEW_INTEGRATION_TITLE,
    description: i18n.VIEW_INTEGRATION_DESCRIPTION,
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: viewIntegrationUrl,
      "data-test-subj": "viewIntegrationButton"
    }, i18n.VIEW_INTEGRATION_BUTTON)
  }))), children);
});
SuccessSection.displayName = 'SuccessSection';