"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCrashGroupDistributionFetcher = useCrashGroupDistributionFetcher;
var _get_comparison_options = require("../components/shared/time_comparison/get_comparison_options");
var _use_apm_params = require("./use_apm_params");
var _use_fetcher = require("./use_fetcher");
var _use_time_range = require("./use_time_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useCrashGroupDistributionFetcher({
  serviceName,
  groupId,
  kuery,
  environment
}) {
  const {
    query: {
      rangeFrom,
      rangeTo,
      offset,
      comparisonEnabled
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/errors', '/mobile-services/{serviceName}/errors-and-crashes');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (start && end) {
      return callApmApi('GET /internal/apm/mobile-services/{serviceName}/crashes/distribution', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            start,
            end,
            offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined,
            groupId
          }
        }
      });
    }
  }, [environment, kuery, serviceName, start, end, offset, groupId, comparisonEnabled]);
  return {
    crashDistributionData: data,
    status
  };
}