"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmTraceWaterfallEmbeddableFactory = void 0;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _presentationContainers = require("@kbn/presentation-containers");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _i18n = require("@kbn/i18n");
var _embeddable_context = require("../embeddable_context");
var _constant = require("./constant");
var _trace_waterfall_embeddable = require("./trace_waterfall_embeddable");
var _focused_trace_waterfall_embeddable = require("./focused_trace_waterfall_embeddable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getApmTraceWaterfallEmbeddableFactory = deps => {
  const factory = {
    type: _constant.APM_TRACE_WATERFALL_EMBEDDABLE,
    buildEmbeddable: async ({
      initialState,
      finalizeApi,
      uuid,
      parentApi
    }) => {
      const state = initialState.rawState;
      const titleManager = (0, _presentationPublishing.initializeTitleManager)(state);
      const serviceName$ = new _rxjs.BehaviorSubject('serviceName' in state ? state.serviceName : '');
      const traceId$ = new _rxjs.BehaviorSubject(state.traceId);
      const entryTransactionId$ = new _rxjs.BehaviorSubject('entryTransactionId' in state ? state.entryTransactionId : '');
      const rangeFrom$ = new _rxjs.BehaviorSubject(state.rangeFrom);
      const rangeTo$ = new _rxjs.BehaviorSubject(state.rangeTo);
      const displayLimit$ = new _rxjs.BehaviorSubject('displayLimit' in state ? state.displayLimit : 0);
      const docId$ = new _rxjs.BehaviorSubject('docId' in state ? state.docId : '');
      const scrollElement$ = new _rxjs.BehaviorSubject('scrollElement' in state ? state.scrollElement : undefined);
      const onNodeClick$ = new _rxjs.BehaviorSubject('onNodeClick' in state ? state.onNodeClick : undefined);
      const getRelatedErrorsHref$ = new _rxjs.BehaviorSubject('getRelatedErrorsHref' in state ? state.getRelatedErrorsHref : undefined);
      function serializeState() {
        return {
          rawState: {
            ...titleManager.getLatestState(),
            serviceName: serviceName$.getValue(),
            traceId: traceId$.getValue(),
            entryTransactionId: entryTransactionId$.getValue(),
            rangeFrom: rangeFrom$.getValue(),
            rangeTo: rangeTo$.getValue(),
            displayLimit: displayLimit$.getValue(),
            docId: docId$.getValue(),
            scrollElement: scrollElement$.getValue(),
            onNodeClick: onNodeClick$.getValue(),
            getRelatedErrorsHref: getRelatedErrorsHref$.getValue()
          }
        };
      }
      const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
        uuid,
        parentApi,
        serializeState,
        anyStateChange$: (0, _rxjs.merge)(titleManager.anyStateChange$, serviceName$, traceId$, entryTransactionId$, rangeFrom$, rangeTo$, displayLimit$, docId$, scrollElement$, onNodeClick$, getRelatedErrorsHref$).pipe((0, _rxjs.map)(() => undefined)),
        getComparators: () => {
          return {
            ..._presentationPublishing.titleComparators,
            serviceName: 'referenceEquality',
            traceId: 'referenceEquality',
            entryTransactionId: 'referenceEquality',
            rangeFrom: 'referenceEquality',
            rangeTo: 'referenceEquality',
            displayLimit: 'referenceEquality',
            docId: 'referenceEquality',
            scrollElement: 'referenceEquality',
            onNodeClick: 'referenceEquality',
            getRelatedErrorsHref: 'referenceEquality'
          };
        },
        onReset: lastSaved => {
          var _lastSaved$rawState$t, _lastSaved$rawState$r, _lastSaved$rawState$r2, _entryState$serviceNa, _entryState$entryTran, _entryState$displayLi, _entryState$scrollEle, _entryState$onNodeCli, _entryState$getRelate, _focusedState$docId;
          titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);

          // reset base state
          traceId$.next((_lastSaved$rawState$t = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState.traceId) !== null && _lastSaved$rawState$t !== void 0 ? _lastSaved$rawState$t : '');
          rangeFrom$.next((_lastSaved$rawState$r = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState.rangeFrom) !== null && _lastSaved$rawState$r !== void 0 ? _lastSaved$rawState$r : '');
          rangeFrom$.next((_lastSaved$rawState$r2 = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState.rangeTo) !== null && _lastSaved$rawState$r2 !== void 0 ? _lastSaved$rawState$r2 : '');

          // reset entry state
          const entryState = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState;
          serviceName$.next((_entryState$serviceNa = entryState === null || entryState === void 0 ? void 0 : entryState.serviceName) !== null && _entryState$serviceNa !== void 0 ? _entryState$serviceNa : '');
          entryTransactionId$.next((_entryState$entryTran = entryState === null || entryState === void 0 ? void 0 : entryState.entryTransactionId) !== null && _entryState$entryTran !== void 0 ? _entryState$entryTran : '');
          displayLimit$.next((_entryState$displayLi = entryState === null || entryState === void 0 ? void 0 : entryState.displayLimit) !== null && _entryState$displayLi !== void 0 ? _entryState$displayLi : 0);
          scrollElement$.next((_entryState$scrollEle = entryState === null || entryState === void 0 ? void 0 : entryState.scrollElement) !== null && _entryState$scrollEle !== void 0 ? _entryState$scrollEle : undefined);
          onNodeClick$.next((_entryState$onNodeCli = entryState === null || entryState === void 0 ? void 0 : entryState.onNodeClick) !== null && _entryState$onNodeCli !== void 0 ? _entryState$onNodeCli : undefined);
          getRelatedErrorsHref$.next((_entryState$getRelate = entryState === null || entryState === void 0 ? void 0 : entryState.getRelatedErrorsHref) !== null && _entryState$getRelate !== void 0 ? _entryState$getRelate : undefined);

          // reset focused state
          const focusedState = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState;
          docId$.next((_focusedState$docId = focusedState === null || focusedState === void 0 ? void 0 : focusedState.docId) !== null && _focusedState$docId !== void 0 ? _focusedState$docId : '');
        }
      });
      const api = finalizeApi({
        ...unsavedChangesApi,
        ...titleManager.api,
        serializeState
      });
      return {
        api,
        Component: () => {
          const [serviceName, traceId, entryTransactionId, rangeFrom, rangeTo, displayLimit, docId, scrollElement, onNodeClick, getRelatedErrorsHref] = (0, _presentationPublishing.useBatchedPublishingSubjects)(serviceName$, traceId$, entryTransactionId$, rangeFrom$, rangeTo$, displayLimit$, docId$, scrollElement$, onNodeClick$, getRelatedErrorsHref$);
          const content = (0, _lodash.isEmpty)(docId) ? /*#__PURE__*/_react.default.createElement(_trace_waterfall_embeddable.TraceWaterfallEmbeddable, {
            serviceName: serviceName,
            traceId: traceId,
            entryTransactionId: entryTransactionId,
            rangeFrom: rangeFrom,
            rangeTo: rangeTo,
            displayLimit: displayLimit,
            onNodeClick: onNodeClick,
            scrollElement: scrollElement,
            getRelatedErrorsHref: getRelatedErrorsHref
          }) : /*#__PURE__*/_react.default.createElement(_focused_trace_waterfall_embeddable.FocusedTraceWaterfallEmbeddable, {
            traceId: traceId,
            rangeFrom: rangeFrom,
            rangeTo: rangeTo,
            docId: docId
          });
          return /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaSectionErrorBoundary, {
            sectionName: _i18n.i18n.translate('xpack.apm.embeddable.traceWaterfall.kibanaSectionErrorBoundary.sectionName', {
              defaultMessage: 'Trace waterfall'
            })
          }, /*#__PURE__*/_react.default.createElement(_embeddable_context.ApmEmbeddableContext, {
            deps: deps,
            rangeFrom: rangeFrom,
            rangeTo: rangeTo
          }, content));
        }
      };
    }
  };
  return factory;
};
exports.getApmTraceWaterfallEmbeddableFactory = getApmTraceWaterfallEmbeddableFactory;