"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoutes = defineRoutes;
var _create = require("./rule/apis/create");
var _get_rule_route = require("./rule/apis/get/get_rule_route");
var _update_rule_route = require("./rule/apis/update/update_rule_route");
var _delete_rule_route = require("./rule/apis/delete/delete_rule_route");
var _aggregate_rules_route = require("./rule/apis/aggregate/aggregate_rules_route");
var _disable_rule_route = require("./rule/apis/disable/disable_rule_route");
var _enable_rule_route = require("./rule/apis/enable/enable_rule_route");
var _find_rules_route = require("./rule/apis/find/find_rules_route");
var _find_internal_rules_route = require("./rule/apis/find/find_internal_rules_route");
var _get_rule_alert_summary = require("./get_rule_alert_summary");
var _get_rule_execution_log = require("./get_rule_execution_log");
var _get_global_execution_logs = require("./get_global_execution_logs");
var _get_global_execution_kpi = require("./get_global_execution_kpi");
var _get_action_error_log = require("./get_action_error_log");
var _get_rule_execution_kpi = require("./get_rule_execution_kpi");
var _get_rule_state = require("./get_rule_state");
var _health = require("./framework/apis/health");
var _resolve = require("./rule/apis/resolve");
var _get_rule_types_route = require("./rule/apis/list_types/external/get_rule_types_route");
var _get_rule_types_internal_route = require("./rule/apis/list_types/internal/get_rule_types_internal_route");
var _mute_all_rule = require("./rule/apis/mute_all/mute_all_rule");
var _mute_alert = require("./rule/apis/mute_alert/mute_alert");
var _unmute_all = require("./rule/apis/unmute_all");
var _unmute_alert_route = require("./rule/apis/unmute_alert/unmute_alert_route");
var _update_rule_api_key_route = require("./rule/apis/update_api_key/update_rule_api_key_route");
var _bulk_edit_rules_route = require("./rule/apis/bulk_edit/bulk_edit_rules_route");
var _snooze = require("./rule/apis/snooze");
var _unsnooze = require("./rule/apis/unsnooze");
var _run_soon = require("./run_soon");
var _bulk_delete_rules_route = require("./rule/apis/bulk_delete/bulk_delete_rules_route");
var _bulk_enable_rules_route = require("./rule/apis/bulk_enable/bulk_enable_rules_route");
var _bulk_disable_rules_route = require("./rule/apis/bulk_disable/bulk_disable_rules_route");
var _clone_rule_route = require("./rule/apis/clone/clone_rule_route");
var _get_flapping_settings = require("./get_flapping_settings");
var _update_flapping_settings = require("./update_flapping_settings");
var _get_rule_tags = require("./rule/apis/tags/get_rule_tags");
var _get_schedule_frequency = require("./rule/apis/get_schedule_frequency");
var _bulk_untrack = require("./rule/apis/bulk_untrack");
var _bulk_untrack_by_query = require("./rule/apis/bulk_untrack_by_query");
var _create_maintenance_window_route = require("./maintenance_window/apis/internal/create/create_maintenance_window_route");
var _get_maintenance_window_route = require("./maintenance_window/apis/internal/get/get_maintenance_window_route");
var _update_maintenance_window_route = require("./maintenance_window/apis/internal/update/update_maintenance_window_route");
var _delete_maintenance_window_route = require("./maintenance_window/apis/internal/delete/delete_maintenance_window_route");
var _find_maintenance_windows_route = require("./maintenance_window/apis/internal/find/find_maintenance_windows_route");
var _archive_maintenance_window_route = require("./maintenance_window/apis/internal/archive/archive_maintenance_window_route");
var _finish_maintenance_window_route = require("./maintenance_window/apis/internal/finish/finish_maintenance_window_route");
var _get_active_maintenance_windows_route = require("./maintenance_window/apis/internal/get_active/get_active_maintenance_windows_route");
var _bulk_get_maintenance_windows_route = require("./maintenance_window/apis/internal/bulk_get/bulk_get_maintenance_windows_route");
var _get_maintenance_window_route2 = require("./maintenance_window/apis/external/get/get_maintenance_window_route");
var _create_maintenance_window_route2 = require("./maintenance_window/apis/external/create/create_maintenance_window_route");
var _delete_maintenance_window_route2 = require("./maintenance_window/apis/external/delete/delete_maintenance_window_route");
var _archive_maintenance_window_route2 = require("./maintenance_window/apis/external/archive/archive_maintenance_window_route");
var _unarchive_maintenance_window_route = require("./maintenance_window/apis/external/unarchive/unarchive_maintenance_window_route");
var _update_maintenance_window_route2 = require("./maintenance_window/apis/external/update/update_maintenance_window_route");
var _values_suggestion_rules = require("./suggestions/values_suggestion_rules");
var _fields_rules = require("./suggestions/fields_rules");
var _values_suggestion_alerts = require("./suggestions/values_suggestion_alerts");
var _get_query_delay_settings = require("./rules_settings/apis/get/get_query_delay_settings");
var _update_query_delay_settings = require("./rules_settings/apis/update/update_query_delay_settings");
var _get_alert_delete_preview_route = require("./alert_delete/apis/preview/get_alert_delete_preview_route");
var _create_alert_delete_schedule_route = require("./alert_delete/apis/schedule/create_alert_delete_schedule_route");
var _get_alert_delete_last_run_route = require("./alert_delete/apis/last_run/get_alert_delete_last_run_route");
var _schedule_backfill_route = require("./backfill/apis/schedule/schedule_backfill_route");
var _get_backfill_route = require("./backfill/apis/get/get_backfill_route");
var _find_backfill_route = require("./backfill/apis/find/find_backfill_route");
var _delete_backfill_route = require("./backfill/apis/delete/delete_backfill_route");
var _find_gaps_route = require("./gaps/apis/find/find_gaps_route");
var _fill_gap_by_id_route = require("./gaps/apis/fill/fill_gap_by_id_route");
var _get_rule_ids_with_gaps_route = require("./gaps/apis/get_rule_ids_with_gaps/get_rule_ids_with_gaps_route");
var _get_gaps_summary_by_rule_ids_route = require("./gaps/apis/get_gaps_summary_by_rule_ids/get_gaps_summary_by_rule_ids_route");
var _get_global_execution_summary = require("./get_global_execution_summary");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// backfill API

// Gaps ApI

function defineRoutes(opts) {
  const {
    router,
    licenseState,
    encryptedSavedObjects,
    usageCounter,
    config$,
    getAlertIndicesAlias,
    alertingConfig,
    core
  } = opts;
  (0, _create.createRuleRoute)(opts);
  (0, _get_rule_route.getRuleRoute)(router, licenseState);
  (0, _get_rule_route.getInternalRuleRoute)(router, licenseState);
  (0, _resolve.resolveRuleRoute)(router, licenseState);
  (0, _update_rule_route.updateRuleRoute)(router, licenseState);
  (0, _delete_rule_route.deleteRuleRoute)(router, licenseState);
  (0, _aggregate_rules_route.aggregateRulesRoute)(router, licenseState);
  (0, _disable_rule_route.disableRuleRoute)(router, licenseState);
  (0, _enable_rule_route.enableRuleRoute)(router, licenseState);
  (0, _find_rules_route.findRulesRoute)(router, licenseState, usageCounter);
  (0, _find_internal_rules_route.findInternalRulesRoute)(router, licenseState, usageCounter);
  (0, _get_rule_alert_summary.getRuleAlertSummaryRoute)(router, licenseState);
  (0, _get_rule_execution_log.getRuleExecutionLogRoute)(router, licenseState);
  (0, _get_rule_execution_kpi.getRuleExecutionKPIRoute)(router, licenseState);
  (0, _get_rule_state.getRuleStateRoute)(router, licenseState);
  (0, _get_rule_types_route.getRuleTypesRoute)(router, licenseState);
  (0, _get_rule_types_internal_route.getRuleTypesInternalRoute)(router, licenseState);
  (0, _mute_all_rule.muteAllRuleRoute)(router, licenseState, usageCounter);
  (0, _unmute_all.unmuteAllRuleRoute)(router, licenseState);
  (0, _update_rule_api_key_route.updateRuleApiKeyRoute)(router, licenseState);
  (0, _bulk_edit_rules_route.bulkEditInternalRulesRoute)(router, licenseState);
  (0, _bulk_delete_rules_route.bulkDeleteRulesRoute)({
    router,
    licenseState
  });
  (0, _bulk_enable_rules_route.bulkEnableRulesRoute)({
    router,
    licenseState
  });
  (0, _bulk_disable_rules_route.bulkDisableRulesRoute)({
    router,
    licenseState
  });
  (0, _snooze.snoozeRuleInternalRoute)(router, licenseState);
  (0, _snooze.snoozeRuleRoute)(router, licenseState);
  (0, _unsnooze.unsnoozeRuleRoute)(router, licenseState);
  (0, _unsnooze.unsnoozeRuleInternalRoute)(router, licenseState);
  (0, _clone_rule_route.cloneRuleRoute)(router, licenseState);
  (0, _get_rule_tags.getRuleTagsRoute)(router, licenseState);
  (0, _values_suggestion_rules.registerRulesValueSuggestionsRoute)(router, licenseState, config$);

  // Alert APIs
  (0, _values_suggestion_alerts.registerAlertsValueSuggestionsRoute)(router, licenseState, config$, getAlertIndicesAlias);
  (0, _bulk_untrack.bulkUntrackAlertsRoute)(router, licenseState);
  (0, _bulk_untrack_by_query.bulkUntrackAlertsByQueryRoute)(router, licenseState);
  (0, _mute_alert.muteAlertRoute)(router, licenseState);
  (0, _unmute_alert_route.unmuteAlertRoute)(router, licenseState);
  (0, _get_alert_delete_preview_route.alertDeletePreviewRoute)(router, licenseState);
  (0, _create_alert_delete_schedule_route.alertDeleteScheduleRoute)(router, licenseState, core);
  (0, _get_alert_delete_last_run_route.alertDeleteLastRunRoute)(router, licenseState);
  if (alertingConfig.maintenanceWindow.enabled) {
    // Maintenance Window - Internal APIs
    (0, _create_maintenance_window_route.createMaintenanceWindowRoute)(router, licenseState);
    (0, _get_maintenance_window_route.getMaintenanceWindowRoute)(router, licenseState);
    (0, _update_maintenance_window_route.updateMaintenanceWindowRoute)(router, licenseState);
    (0, _delete_maintenance_window_route.deleteMaintenanceWindowRoute)(router, licenseState);
    (0, _find_maintenance_windows_route.findMaintenanceWindowsRoute)(router, licenseState);
    (0, _archive_maintenance_window_route.archiveMaintenanceWindowRoute)(router, licenseState);
    (0, _finish_maintenance_window_route.finishMaintenanceWindowRoute)(router, licenseState);
    (0, _get_active_maintenance_windows_route.getActiveMaintenanceWindowsRoute)(router, licenseState);
    (0, _bulk_get_maintenance_windows_route.bulkGetMaintenanceWindowRoute)(router, licenseState);

    // Maintenance Window - External APIs
    (0, _get_maintenance_window_route2.getMaintenanceWindowRoute)(router, licenseState);
    (0, _create_maintenance_window_route2.createMaintenanceWindowRoute)(router, licenseState);
    (0, _delete_maintenance_window_route2.deleteMaintenanceWindowRoute)(router, licenseState);
    (0, _archive_maintenance_window_route2.archiveMaintenanceWindowRoute)(router, licenseState);
    (0, _unarchive_maintenance_window_route.unarchiveMaintenanceWindowRoute)(router, licenseState);
    (0, _update_maintenance_window_route2.updateMaintenanceWindowRoute)(router, licenseState);
  }
  // backfill APIs
  (0, _schedule_backfill_route.scheduleBackfillRoute)(router, licenseState);
  (0, _get_backfill_route.getBackfillRoute)(router, licenseState);
  (0, _find_backfill_route.findBackfillRoute)(router, licenseState);
  (0, _delete_backfill_route.deleteBackfillRoute)(router, licenseState);

  // Gaps APIs
  (0, _find_gaps_route.findGapsRoute)(router, licenseState);
  (0, _fill_gap_by_id_route.fillGapByIdRoute)(router, licenseState);
  (0, _get_rule_ids_with_gaps_route.getRuleIdsWithGapsRoute)(router, licenseState);
  (0, _get_gaps_summary_by_rule_ids_route.getGapsSummaryByRuleIdsRoute)(router, licenseState);

  // Rules Settings APIs
  if (alertingConfig.rulesSettings.enabled) {
    (0, _get_query_delay_settings.getQueryDelaySettingsRoute)(router, licenseState);
    (0, _update_query_delay_settings.updateQueryDelaySettingsRoute)(router, licenseState);
    (0, _get_flapping_settings.getFlappingSettingsRoute)(router, licenseState);
    (0, _update_flapping_settings.updateFlappingSettingsRoute)(router, licenseState);
  }
  // Other APIs
  (0, _fields_rules.registerFieldsRoute)(router, licenseState);
  (0, _get_schedule_frequency.getScheduleFrequencyRoute)(router, licenseState);
  (0, _get_global_execution_logs.getGlobalExecutionLogRoute)(router, licenseState);
  (0, _get_action_error_log.getActionErrorLogRoute)(router, licenseState);
  (0, _run_soon.runSoonRoute)(router, licenseState);
  (0, _health.healthRoute)(router, licenseState, encryptedSavedObjects);
  (0, _get_global_execution_kpi.getGlobalExecutionKPIRoute)(router, licenseState);
  (0, _get_global_execution_summary.getGlobalExecutionSummaryRoute)(router, licenseState);
}