/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.reflect;

import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.backward_codecs.lucene90.Lucene90HnswVectorsReader;
import org.apache.lucene.backward_codecs.lucene91.Lucene91HnswVectorsReader;
import org.apache.lucene.backward_codecs.lucene92.Lucene92HnswVectorsReader;
import org.apache.lucene.backward_codecs.lucene94.Lucene94HnswVectorsReader;
import org.apache.lucene.backward_codecs.lucene95.Lucene95HnswVectorsReader;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorsReader;
import org.apache.lucene.index.FieldInfo;
import org.elasticsearch.index.codec.vectors.reflect.AssertingKnnVectorsReaderReflect;
import org.elasticsearch.index.codec.vectors.reflect.OffHeapReflectionUtils;
import org.elasticsearch.index.codec.vectors.reflect.OffHeapStats;

public class OffHeapByteSizeUtils {
    private OffHeapByteSizeUtils() {
    }

    public static Map<String, Long> getOffHeapByteSize(KnnVectorsReader reader, FieldInfo fieldInfo) {
        KnnVectorsReader knnVectorsReader = reader = AssertingKnnVectorsReaderReflect.unwrapAssertingReader(reader);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OffHeapStats.class, Lucene99HnswVectorsReader.class, Lucene99ScalarQuantizedVectorsReader.class, Lucene99FlatVectorsReader.class, Lucene95HnswVectorsReader.class, Lucene94HnswVectorsReader.class, Lucene92HnswVectorsReader.class, Lucene91HnswVectorsReader.class, Lucene90HnswVectorsReader.class}, (Object)knnVectorsReader, n)) {
            case 0: {
                OffHeapStats offHeapStats = (OffHeapStats)knnVectorsReader;
                return offHeapStats.getOffHeapByteSize(fieldInfo);
            }
            case 1: {
                Lucene99HnswVectorsReader hnswVectorsReader = (Lucene99HnswVectorsReader)knnVectorsReader;
                Map<String, Long> graph = OffHeapReflectionUtils.getOffHeapByteSizeL99HNSW(hnswVectorsReader, fieldInfo);
                Map<String, Long> flat = OffHeapByteSizeUtils.getOffHeapByteSize((KnnVectorsReader)OffHeapReflectionUtils.getFlatVectorsReaderL99HNSW(hnswVectorsReader), fieldInfo);
                return OffHeapByteSizeUtils.mergeOffHeapByteSizeMaps(graph, flat);
            }
            case 2: {
                Lucene99ScalarQuantizedVectorsReader scalarQuantizedVectorsReader = (Lucene99ScalarQuantizedVectorsReader)knnVectorsReader;
                Map<String, Long> quant = OffHeapReflectionUtils.getOffHeapByteSizeSQ(scalarQuantizedVectorsReader, fieldInfo);
                Map<String, Long> raw = OffHeapByteSizeUtils.getOffHeapByteSize((KnnVectorsReader)OffHeapReflectionUtils.getFlatVectorsReaderSQ(scalarQuantizedVectorsReader), fieldInfo);
                return OffHeapByteSizeUtils.mergeOffHeapByteSizeMaps(quant, raw);
            }
            case 3: {
                Lucene99FlatVectorsReader flatVectorsReader = (Lucene99FlatVectorsReader)knnVectorsReader;
                return OffHeapReflectionUtils.getOffHeapByteSizeF99FLT(flatVectorsReader, fieldInfo);
            }
            case 4: {
                Lucene95HnswVectorsReader lucene95HnswVectorsReader = (Lucene95HnswVectorsReader)knnVectorsReader;
                return OffHeapReflectionUtils.getOffHeapByteSizeL95HNSW(lucene95HnswVectorsReader, fieldInfo);
            }
            case 5: {
                Lucene94HnswVectorsReader lucene94HnswVectorsReader = (Lucene94HnswVectorsReader)knnVectorsReader;
                return OffHeapReflectionUtils.getOffHeapByteSizeL94HNSW(lucene94HnswVectorsReader, fieldInfo);
            }
            case 6: {
                Lucene92HnswVectorsReader lucene92HnswVectorsReader = (Lucene92HnswVectorsReader)knnVectorsReader;
                return OffHeapReflectionUtils.getOffHeapByteSizeL92HNSW(lucene92HnswVectorsReader, fieldInfo);
            }
            case 7: {
                Lucene91HnswVectorsReader lucene91HnswVectorsReader = (Lucene91HnswVectorsReader)knnVectorsReader;
                return OffHeapReflectionUtils.getOffHeapByteSizeL91HNSW(lucene91HnswVectorsReader, fieldInfo);
            }
            case 8: {
                Lucene90HnswVectorsReader lucene90HnswVectorsReader = (Lucene90HnswVectorsReader)knnVectorsReader;
                return OffHeapReflectionUtils.getOffHeapByteSizeL90HNSW(lucene90HnswVectorsReader, fieldInfo);
            }
        }
        assert (false) : "unexpected reader:" + String.valueOf(reader);
        return Map.of();
    }

    public static Map<String, Long> mergeOffHeapByteSizeMaps(Map<String, Long> map1, Map<String, Long> map2) {
        return Stream.of(map1, map2).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Long::sum));
    }
}

