/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermissions;
import org.elasticsearch.cli.Terminal;

public class FileAttributesChecker {
    private final Path[] paths;
    private final PosixFileAttributes[] attributes;

    public FileAttributesChecker(Path ... paths) throws IOException {
        this.paths = paths;
        this.attributes = new PosixFileAttributes[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            PosixFileAttributeView view;
            if (!Files.exists(paths[i], new LinkOption[0]) || (view = Files.getFileAttributeView(paths[i], PosixFileAttributeView.class, new LinkOption[0])) == null) continue;
            this.attributes[i] = view.readAttributes();
        }
    }

    public void check(Terminal terminal) throws IOException {
        for (int i = 0; i < this.paths.length; ++i) {
            if (this.attributes[i] == null) continue;
            PosixFileAttributeView view = Files.getFileAttributeView(this.paths[i], PosixFileAttributeView.class, new LinkOption[0]);
            PosixFileAttributes newAttributes = view.readAttributes();
            PosixFileAttributes oldAttributes = this.attributes[i];
            if (!oldAttributes.permissions().equals(newAttributes.permissions())) {
                terminal.errorPrintln(Terminal.Verbosity.SILENT, "WARNING: The file permissions of [" + String.valueOf(this.paths[i]) + "] have changed from [" + PosixFilePermissions.toString(oldAttributes.permissions()) + "] to [" + PosixFilePermissions.toString(newAttributes.permissions()) + "]");
                terminal.errorPrintln(Terminal.Verbosity.SILENT, "Please ensure that the user account running Elasticsearch has read access to this file!");
            }
            if (!oldAttributes.owner().getName().equals(newAttributes.owner().getName())) {
                terminal.errorPrintln(Terminal.Verbosity.SILENT, "WARNING: Owner of file [" + String.valueOf(this.paths[i]) + "] used to be [" + oldAttributes.owner().getName() + "], but now is [" + newAttributes.owner().getName() + "]");
            }
            if (oldAttributes.group().getName().equals(newAttributes.group().getName())) continue;
            terminal.errorPrintln(Terminal.Verbosity.SILENT, "WARNING: Group of file [" + String.valueOf(this.paths[i]) + "] used to be [" + oldAttributes.group().getName() + "], but now is [" + newAttributes.group().getName() + "]");
        }
    }
}

