/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.geo.BoundingBox;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.SpatialBounds;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class InternalBounds<T extends SpatialPoint>
extends InternalAggregation
implements SpatialBounds<T> {
    public final double top;
    public final double bottom;

    public InternalBounds(String name, double top, double bottom, Map<String, Object> metadata) {
        super(name, metadata);
        this.top = top;
        this.bottom = bottom;
    }

    public InternalBounds(StreamInput in) throws IOException {
        super(in);
        this.top = in.readDouble();
        this.bottom = in.readDouble();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeDouble(this.top);
        out.writeDouble(this.bottom);
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return this;
    }

    @Override
    protected boolean mustReduceOnSingleInternalAgg() {
        return false;
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1) {
            String bBoxSide;
            BoundingBox<T> bbox = this.resolveBoundingBox();
            return switch (bBoxSide = path.get(0)) {
                case "top" -> bbox.top();
                case "left" -> bbox.left();
                case "bottom" -> bbox.bottom();
                case "right" -> bbox.right();
                default -> throw new IllegalArgumentException("Found unknown path element [" + bBoxSide + "] in [" + this.getName() + "]");
            };
        }
        if (path.size() == 2) {
            String cornerString;
            BoundingBox<T> bbox = this.resolveBoundingBox();
            SpatialPoint cornerPoint = switch (cornerString = path.get(0)) {
                case "top_left" -> (SpatialPoint)bbox.topLeft();
                case "bottom_right" -> (SpatialPoint)bbox.bottomRight();
                default -> throw new IllegalArgumentException("Found unknown path element [" + cornerString + "] in [" + this.getName() + "]");
            };
            return this.selectCoordinate(path.get(1), cornerPoint);
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + String.valueOf(path));
    }

    protected abstract Object selectCoordinate(String var1, T var2);

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        BoundingBox<T> bbox = this.resolveBoundingBox();
        if (bbox != null) {
            builder.startObject(GeoBoundingBox.BOUNDS_FIELD.getPreferredName());
            bbox.toXContentFragment(builder);
            builder.endObject();
        }
        return builder;
    }

    protected abstract BoundingBox<T> resolveBoundingBox();

    @Override
    public T topLeft() {
        BoundingBox<T> bbox = this.resolveBoundingBox();
        if (bbox == null) {
            return null;
        }
        return bbox.topLeft();
    }

    @Override
    public T bottomRight() {
        BoundingBox<T> bbox = this.resolveBoundingBox();
        if (bbox == null) {
            return null;
        }
        return bbox.bottomRight();
    }
}

