/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.DataStreamTimestampFieldMapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.xcontent.XContentType;

public final class MappingParser {
    private final Supplier<MappingParserContext> mappingParserContextSupplier;
    private final Supplier<Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>> metadataMappersSupplier;
    private final Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers;
    private final Function<String, String> documentTypeResolver;
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(MappingParser.class);

    MappingParser(Supplier<MappingParserContext> mappingParserContextSupplier, Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers, Supplier<Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>> metadataMappersSupplier, Function<String, String> documentTypeResolver) {
        this.mappingParserContextSupplier = mappingParserContextSupplier;
        this.metadataMapperParsers = metadataMapperParsers;
        this.metadataMappersSupplier = metadataMappersSupplier;
        this.documentTypeResolver = documentTypeResolver;
    }

    public static void checkNoRemainingFields(String fieldName, Map<?, ?> fieldNodeMap) {
        MappingParser.checkNoRemainingFields(fieldNodeMap, "Mapping definition for [" + fieldName + "] has unsupported parameters: ");
    }

    public static void checkNoRemainingFields(Map<?, ?> fieldNodeMap, String message) {
        if (!fieldNodeMap.isEmpty()) {
            throw new MapperParsingException(message + MappingParser.getRemainingFields(fieldNodeMap));
        }
    }

    private static String getRemainingFields(Map<?, ?> map) {
        StringBuilder remainingFields = new StringBuilder();
        for (Object key : map.keySet()) {
            remainingFields.append(" [").append(key).append(" : ").append(map.get(key)).append("]");
        }
        return remainingFields.toString();
    }

    static Map<String, Object> convertToMap(CompressedXContent source) {
        Objects.requireNonNull(source, "source cannot be null");
        return (Map)XContentHelper.convertToMap(source.compressedReference(), true, XContentType.JSON).v2();
    }

    Mapping parse(@Nullable String type, CompressedXContent source) throws MapperParsingException {
        return this.parse(type, MapperService.MergeReason.MAPPING_UPDATE, source);
    }

    Mapping parse(@Nullable String type, MapperService.MergeReason reason, CompressedXContent source) throws MapperParsingException {
        Map<String, Object> mapping = MappingParser.convertToMap(source);
        return this.parse(type, reason, mapping);
    }

    Mapping parse(@Nullable String type, MapperService.MergeReason reason, Map<String, Object> mappingSource) throws MapperParsingException {
        if (mappingSource.isEmpty()) {
            if (type == null) {
                throw new MapperParsingException("malformed mapping, no type name found");
            }
        } else {
            String rootName = mappingSource.keySet().iterator().next();
            if (type == null || type.equals(rootName) || this.documentTypeResolver.apply(type).equals(rootName)) {
                type = rootName;
                mappingSource = (Map)mappingSource.get(rootName);
            }
        }
        if (type == null) {
            throw new MapperParsingException("Failed to derive type");
        }
        if (type.isEmpty()) {
            throw new MapperParsingException("type cannot be an empty string");
        }
        MappingParserContext mappingParserContext = this.mappingParserContextSupplier.get();
        RootObjectMapper.Builder rootObjectMapper = RootObjectMapper.parse(type, mappingSource, mappingParserContext);
        Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappers = this.metadataMappersSupplier.get();
        Map<String, Object> meta = null;
        boolean isSourceSynthetic = SourceFieldMapper.isSynthetic(mappingParserContext.getIndexSettings());
        boolean isDataStream = false;
        Iterator iterator = mappingSource.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String fieldName = (String)entry.getKey();
            Object fieldNode = entry.getValue();
            MetadataFieldMapper.TypeParser typeParser = this.metadataMapperParsers.get(fieldName);
            if (typeParser == null) continue;
            iterator.remove();
            if (!(fieldNode instanceof Map)) {
                throw new IllegalArgumentException("[" + fieldName + "] config must be an object");
            }
            Map fieldNodeMap = (Map)fieldNode;
            if (reason == MapperService.MergeReason.INDEX_TEMPLATE && "_source".equals(fieldName) && fieldNodeMap.containsKey("mode") && SourceFieldMapper.onOrAfterDeprecateModeVersion(mappingParserContext.indexVersionCreated())) {
                deprecationLogger.critical(DeprecationCategory.MAPPINGS, "mapping_source_mode", "Configuring source mode in mappings is deprecated and will be removed in future versions. Use [index.mapping.source.mode] index setting instead.", new Object[0]);
            }
            MetadataFieldMapper metadataFieldMapper = typeParser.parse(fieldName, fieldNodeMap, mappingParserContext).build();
            metadataMappers.put(metadataFieldMapper.getClass(), metadataFieldMapper);
            assert (fieldNodeMap.isEmpty());
            if (metadataFieldMapper instanceof SourceFieldMapper) {
                SourceFieldMapper sfm = (SourceFieldMapper)metadataFieldMapper;
                isSourceSynthetic = sfm.isSynthetic();
            }
            if (!(metadataFieldMapper instanceof DataStreamTimestampFieldMapper)) continue;
            DataStreamTimestampFieldMapper dsfm = (DataStreamTimestampFieldMapper)metadataFieldMapper;
            isDataStream = dsfm.isEnabled();
        }
        Map removed = (Map)mappingSource.remove("_meta");
        if (removed != null) {
            meta = Collections.unmodifiableMap(new HashMap(removed));
        }
        if (!mappingParserContext.indexVersionCreated().isLegacyIndexVersion()) {
            MappingParser.checkNoRemainingFields(mappingSource, "Root mapping definition has unsupported parameters: ");
        }
        return new Mapping(rootObjectMapper.build(MapperBuilderContext.root(isSourceSynthetic, isDataStream, reason)), metadataMappers.values().toArray(new MetadataFieldMapper[0]), meta);
    }
}

