/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceMetrics;

public record BalancingRoundSummary(Map<String, NodesWeightsChanges> nodeNameToWeightChanges, long numberOfShardsToMove) {
    @Override
    public String toString() {
        return "BalancingRoundSummary{nodeNameToWeightChanges" + String.valueOf(this.nodeNameToWeightChanges) + ", numberOfShardsToMove=" + this.numberOfShardsToMove + "}";
    }

    public record CombinedBalancingRoundSummary(int numberOfBalancingRounds, Map<String, NodesWeightsChanges> nodeNameToWeightChanges, long numberOfShardMoves) {
        public static final CombinedBalancingRoundSummary EMPTY_RESULTS = new CombinedBalancingRoundSummary(0, new HashMap<String, NodesWeightsChanges>(), 0L);

        public static CombinedBalancingRoundSummary combine(List<BalancingRoundSummary> summaries) {
            if (summaries.isEmpty()) {
                return EMPTY_RESULTS;
            }
            HashMap<String, NodesWeightsChanges> combinedNodeNameToWeightChanges = new HashMap<String, NodesWeightsChanges>();
            long numberOfShardMoves = 0L;
            int numSummaries = 0;
            for (BalancingRoundSummary summary : summaries) {
                for (Map.Entry<String, NodesWeightsChanges> nodeNameAndWeights : summary.nodeNameToWeightChanges.entrySet()) {
                    NodesWeightsChanges combined = (NodesWeightsChanges)combinedNodeNameToWeightChanges.get(nodeNameAndWeights.getKey());
                    if (combined == null) {
                        combinedNodeNameToWeightChanges.put(nodeNameAndWeights.getKey(), nodeNameAndWeights.getValue());
                        continue;
                    }
                    NodesWeightsChanges newCombinedChanges = new NodesWeightsChanges(combined.baseWeights, combined.weightsDiff.combine(nodeNameAndWeights.getValue().weightsDiff()));
                    combinedNodeNameToWeightChanges.put(nodeNameAndWeights.getKey(), newCombinedChanges);
                }
                ++numSummaries;
                numberOfShardMoves += summary.numberOfShardsToMove();
            }
            return new CombinedBalancingRoundSummary(numSummaries, combinedNodeNameToWeightChanges, numberOfShardMoves);
        }
    }

    record NodeWeightsDiff(long shardCountDiff, double diskUsageInBytesDiff, double writeLoadDiff, double totalWeightDiff) {
        public static NodeWeightsDiff create(DesiredBalanceMetrics.NodeWeightStats base, DesiredBalanceMetrics.NodeWeightStats next) {
            return new NodeWeightsDiff(next.shardCount() - base.shardCount(), next.diskUsageInBytes() - base.diskUsageInBytes(), next.writeLoad() - base.writeLoad(), next.nodeWeight() - base.nodeWeight());
        }

        public NodeWeightsDiff combine(NodeWeightsDiff otherDiff) {
            return new NodeWeightsDiff(this.shardCountDiff + otherDiff.shardCountDiff, this.diskUsageInBytesDiff + otherDiff.diskUsageInBytesDiff, this.writeLoadDiff + otherDiff.writeLoadDiff, this.totalWeightDiff + otherDiff.totalWeightDiff);
        }
    }

    record NodesWeightsChanges(DesiredBalanceMetrics.NodeWeightStats baseWeights, NodeWeightsDiff weightsDiff) {
    }
}

