/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.project;

import java.util.Collection;
import java.util.Map;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.core.CheckedRunnable;

public class DefaultProjectResolver
implements ProjectResolver {
    public static final DefaultProjectResolver INSTANCE = new DefaultProjectResolver();

    @Override
    public ProjectMetadata getProjectMetadata(Metadata metadata) {
        assert (this.assertSingleProject(metadata));
        return ProjectResolver.super.getProjectMetadata(metadata);
    }

    @Override
    public ProjectId getProjectId() {
        return Metadata.DEFAULT_PROJECT_ID;
    }

    @Override
    public Collection<ProjectId> getProjectIds(ClusterState clusterState) {
        assert (this.assertSingleProject(clusterState.metadata()));
        return ProjectResolver.super.getProjectIds(clusterState);
    }

    private boolean assertSingleProject(Metadata metadata) {
        Map<ProjectId, ProjectMetadata> projects = metadata.projects();
        assert (projects.size() == 1 && projects.containsKey(this.getProjectId())) : "expect only default projects, but got " + String.valueOf(projects.keySet());
        return true;
    }

    @Override
    public <E extends Exception> void executeOnProject(ProjectId projectId, CheckedRunnable<E> body) throws E {
        if (!projectId.equals(Metadata.DEFAULT_PROJECT_ID)) {
            throw new IllegalArgumentException("Cannot execute on a project other than [" + String.valueOf(Metadata.DEFAULT_PROJECT_ID) + "]");
        }
        body.run();
    }
}

