/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.post;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.post.SimulateIndexTemplateResponse;
import org.elasticsearch.action.admin.indices.template.post.SimulateTemplateAction;
import org.elasticsearch.action.admin.indices.template.post.TransportSimulateIndexTemplateAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.local.TransportLocalProjectMetadataAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexSettingProviders;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class TransportSimulateTemplateAction
extends TransportLocalProjectMetadataAction<SimulateTemplateAction.Request, SimulateIndexTemplateResponse> {
    private final MetadataIndexTemplateService indexTemplateService;
    private final NamedXContentRegistry xContentRegistry;
    private final IndicesService indicesService;
    private final SystemIndices systemIndices;
    private final Set<IndexSettingProvider> indexSettingProviders;
    private final ClusterSettings clusterSettings;
    private final boolean isDslOnlyMode;

    @Inject
    public TransportSimulateTemplateAction(TransportService transportService, ClusterService clusterService, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry, IndicesService indicesService, SystemIndices systemIndices, IndexSettingProviders indexSettingProviders, ProjectResolver projectResolver) {
        super("indices:admin/index_template/simulate", actionFilters, transportService.getTaskManager(), clusterService, EsExecutors.DIRECT_EXECUTOR_SERVICE, projectResolver);
        this.indexTemplateService = indexTemplateService;
        this.xContentRegistry = xContentRegistry;
        this.indicesService = indicesService;
        this.systemIndices = systemIndices;
        this.indexSettingProviders = indexSettingProviders.getIndexSettingProviders();
        this.clusterSettings = clusterService.getClusterSettings();
        this.isDslOnlyMode = DataStreamLifecycle.isDataStreamsLifecycleOnlyMode(clusterService.getSettings());
        transportService.registerRequestHandler(this.actionName, this.executor, false, true, SimulateTemplateAction.Request::new, (request, channel, task) -> this.executeDirect(task, request, new ChannelActionListener(channel)));
    }

    @Override
    protected void localClusterStateOperation(Task task, SimulateTemplateAction.Request request, ProjectState state, ActionListener<SimulateIndexTemplateResponse> listener) throws Exception {
        ProjectMetadata projectWithTemplate;
        Object simulateTemplateToAdd;
        String uuid = UUIDs.randomBase64UUID().toLowerCase(Locale.ROOT);
        String temporaryIndexName = "simulate_template_index_" + uuid;
        if (request.getIndexTemplateRequest() != null) {
            simulateTemplateToAdd = request.getTemplateName() == null ? "simulate_template_" + uuid : request.getTemplateName();
            MetadataIndexTemplateService.validateV2TemplateRequest(state.metadata(), (String)simulateTemplateToAdd, request.getIndexTemplateRequest().indexTemplate());
            projectWithTemplate = this.indexTemplateService.addIndexTemplateV2(state.metadata(), request.getIndexTemplateRequest().create(), (String)simulateTemplateToAdd, request.getIndexTemplateRequest().indexTemplate());
        } else {
            simulateTemplateToAdd = null;
            projectWithTemplate = state.metadata();
        }
        Object matchingTemplate = request.getTemplateName() == null ? simulateTemplateToAdd : request.getTemplateName();
        if (matchingTemplate == null) {
            listener.onFailure(new IllegalArgumentException("a template name to match or a new template body must be specified"));
            return;
        }
        if (!projectWithTemplate.templatesV2().containsKey(matchingTemplate)) {
            listener.onFailure(new IllegalArgumentException("unable to simulate template [" + (String)matchingTemplate + "] that does not exist"));
            return;
        }
        ProjectMetadata tempProjectMetadata = TransportSimulateIndexTemplateAction.resolveTemporaryState((String)matchingTemplate, temporaryIndexName, projectWithTemplate);
        ComposableIndexTemplate templateV2 = tempProjectMetadata.templatesV2().get(matchingTemplate);
        assert (templateV2 != null) : "the matched template must exist";
        HashMap<String, List<String>> overlapping = new HashMap<String, List<String>>();
        overlapping.putAll(MetadataIndexTemplateService.findConflictingV1Templates(tempProjectMetadata, (String)matchingTemplate, templateV2.indexPatterns()));
        overlapping.putAll(MetadataIndexTemplateService.findConflictingV2Templates(tempProjectMetadata, (String)matchingTemplate, templateV2.indexPatterns()));
        Template template = TransportSimulateIndexTemplateAction.resolveTemplate((String)matchingTemplate, temporaryIndexName, projectWithTemplate, this.isDslOnlyMode, this.xContentRegistry, this.indicesService, this.systemIndices, this.indexSettingProviders);
        if (request.includeDefaults()) {
            listener.onResponse(new SimulateIndexTemplateResponse(template, overlapping, this.clusterSettings.get(DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING)));
        } else {
            listener.onResponse(new SimulateIndexTemplateResponse(template, overlapping));
        }
    }

    @Override
    protected ClusterBlockException checkBlock(SimulateTemplateAction.Request request, ProjectState state) {
        return state.blocks().globalBlockedException(state.projectId(), ClusterBlockLevel.METADATA_READ);
    }
}

