/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.Objects;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.RequestBuilder;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.core.TimeValue;

public abstract class ActionRequestBuilder<Request extends ActionRequest, Response extends ActionResponse>
implements RequestBuilder<Request, Response> {
    protected final ActionType<Response> action;
    protected final Request request;
    protected final ElasticsearchClient client;

    protected ActionRequestBuilder(ElasticsearchClient client, ActionType<Response> action, Request request) {
        Objects.requireNonNull(action, "action must not be null");
        this.action = action;
        this.request = request;
        this.client = client;
    }

    @Override
    public Request request() {
        return this.request;
    }

    @Override
    public ActionFuture<Response> execute() {
        return this.client.execute(this.action, this.request);
    }

    @Override
    public Response get() {
        return (Response)((ActionResponse)this.execute().actionGet());
    }

    @Override
    public Response get(TimeValue timeout) {
        return (Response)((ActionResponse)this.execute().actionGet(timeout));
    }

    @Override
    public void execute(ActionListener<Response> listener) {
        this.client.execute(this.action, this.request, listener);
    }
}

