/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.parser;

import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.ql.parser.ParserUtils;
import org.elasticsearch.xpack.ql.plan.TableIdentifier;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.sql.parser.AbstractBuilder;
import org.elasticsearch.xpack.sql.parser.ParsingException;
import org.elasticsearch.xpack.sql.parser.SqlBaseParser;

abstract class IdentifierBuilder
extends AbstractBuilder {
    IdentifierBuilder() {
    }

    @Override
    public TableIdentifier visitTableIdentifier(SqlBaseParser.TableIdentifierContext ctx) {
        if (ctx == null) {
            return null;
        }
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        SqlBaseParser.IdentifierContext tree = ctx.name != null ? ctx.name : ctx.TABLE_IDENTIFIER();
        String index = tree.getText();
        String cluster = this.visitIdentifier(ctx.catalog);
        String indexName = IdentifierBuilder.unquoteIdentifier(index);
        String selector = this.visitIdentifier(ctx.selector);
        if (cluster != null && selector != null) {
            throw new ParsingException(source, "Invalid index name [{}:{}::{}], Selectors are not yet supported on remote cluster patterns", cluster, indexName, selector);
        }
        if (selector != null) {
            try {
                IndexNameExpressionResolver.SelectorResolver.validateIndexSelectorString((String)indexName, (String)selector);
            }
            catch (Exception e) {
                throw new ParsingException(source, e.getMessage(), new Object[0]);
            }
        }
        if (indexName.contains("::")) {
            if (selector != null) {
                throw new ParsingException(source, "Invalid index name [{}::{}], Invalid usage of :: separator, only one :: separator is allowed per expression", indexName, selector);
            }
            try {
                Tuple split = IndexNameExpressionResolver.splitSelectorExpression((String)indexName);
                indexName = (String)split.v1();
                selector = (String)split.v2();
            }
            catch (Exception e) {
                throw new ParsingException(source, e.getMessage(), new Object[0]);
            }
            if (selector != null) {
                try {
                    IndexNameExpressionResolver.SelectorResolver.validateIndexSelectorString((String)indexName, (String)selector);
                }
                catch (Exception e) {
                    throw new ParsingException(source, "Invalid index name [{}::{}], {}", indexName, selector, e.getMessage());
                }
            }
        }
        indexName = IndexNameExpressionResolver.combineSelectorExpression((String)indexName, (String)selector);
        return new TableIdentifier(source, cluster, indexName);
    }

    @Override
    public String visitIdentifier(SqlBaseParser.IdentifierContext ctx) {
        return ctx == null ? null : IdentifierBuilder.unquoteIdentifier(ctx.getText());
    }

    @Override
    public String visitQualifiedName(SqlBaseParser.QualifiedNameContext ctx) {
        if (ctx == null) {
            return null;
        }
        return Strings.collectionToDelimitedString((Iterable)ParserUtils.visitList((ParseTreeVisitor)this, ctx.identifier(), String.class), (String)".");
    }

    private static String unquoteIdentifier(String identifier) {
        return identifier.replace("\"\"", "\"");
    }
}

