/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.index;

import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.proto.SqlVersion;
import org.elasticsearch.xpack.sql.proto.VersionCompatibility;

public final class VersionCompatibilityChecks {
    public static final TransportVersion INTRODUCING_UNSIGNED_LONG_TRANSPORT = TransportVersions.V_8_2_0;

    private VersionCompatibilityChecks() {
    }

    public static boolean isTypeSupportedInVersion(DataType dataType, SqlVersion version) {
        if (dataType == DataTypes.UNSIGNED_LONG) {
            return VersionCompatibility.supportsUnsignedLong((SqlVersion)version);
        }
        if (dataType == DataTypes.VERSION) {
            return VersionCompatibility.supportsVersionType((SqlVersion)version);
        }
        return true;
    }

    @Nullable
    public static SqlVersion versionIntroducingType(DataType dataType) {
        if (dataType == DataTypes.UNSIGNED_LONG) {
            return VersionCompatibility.INTRODUCING_UNSIGNED_LONG;
        }
        if (dataType == DataTypes.VERSION) {
            return VersionCompatibility.INTRODUCING_VERSION_FIELD_TYPE;
        }
        return null;
    }
}

