/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.array.BasicArray;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.matrix.decomposition.AbstractDecomposition;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.store.DiagonalStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.Rotation;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;

abstract class GenericDecomposition<N extends Comparable<N>>
extends AbstractDecomposition<N> {
    private final PhysicalStore.Factory<N, ? extends DecompositionStore<N>> myFactory;

    protected GenericDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> factory) {
        this.myFactory = factory;
    }

    protected final AggregatorSet<N> aggregator() {
        return this.myFactory.aggregator();
    }

    @Override
    protected final DecompositionStore<N> allocate(long numberOfRows, long numberOfColumns) {
        return (DecompositionStore)this.myFactory.make(numberOfRows, numberOfColumns);
    }

    protected final MatrixStore<N> collect(Access2D.Collectable<N, ? super DecompositionStore<N>> source) {
        if (source instanceof MatrixStore) {
            return (MatrixStore)source;
        }
        if (source instanceof Access2D) {
            return this.myFactory.makeWrapper((Access2D)((Object)source));
        }
        return (MatrixStore)source.collect(this.myFactory);
    }

    protected final DecompositionStore<N> copy(Access2D<?> source) {
        return (DecompositionStore)this.myFactory.copy(source);
    }

    @Override
    protected final FunctionSet<N> function() {
        return this.myFactory.function();
    }

    protected final BasicArray<N> makeArray(int length) {
        return (BasicArray)this.myFactory.array().make(length);
    }

    protected final <D extends Access1D<?>> DiagonalStore.Builder<N, D> makeDiagonal(D mainDiag) {
        return DiagonalStore.builder(this.myFactory, mainDiag);
    }

    protected final DecompositionStore<N> makeEye(int numberOfRows, int numberOfColumns) {
        return this.myFactory.makeEye(numberOfRows, numberOfColumns);
    }

    protected final Householder<N> makeHouseholder(int dimension) {
        return this.myFactory.makeHouseholder(dimension);
    }

    protected final MatrixStore<N> makeIdentity(int dimension) {
        return this.myFactory.makeIdentity(dimension);
    }

    protected final Rotation<N> makeRotation(int low, int high, double cos, double sin) {
        return this.myFactory.makeRotation(low, high, cos, sin);
    }

    protected final Rotation<N> makeRotation(int low, int high, N cos, N sin) {
        return this.myFactory.makeRotation(low, high, cos, sin);
    }

    protected final DecompositionStore<N> makeZero(int numberOfRows, int numberOfColumns) {
        return (DecompositionStore)this.myFactory.make(numberOfRows, numberOfColumns);
    }

    protected final DecompositionStore<N> makeZero(Structure2D shape) {
        return (DecompositionStore)this.myFactory.make(shape);
    }

    @Override
    protected final Scalar.Factory<N> scalar() {
        return this.myFactory.scalar();
    }

    protected final MatrixStore<N> wrap(Access2D<?> source) {
        return this.myFactory.makeWrapper(source);
    }
}

