/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid;

import java.io.IOException;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.Geohash;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashBoundedPredicate;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoRelation;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.ShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoShapeCellValues;

public abstract class GeoHashGridTiler
extends GeoGridTiler {
    private GeoHashGridTiler(int precision) {
        super(precision);
    }

    public static GeoHashGridTiler makeGridTiler(int precision, GeoBoundingBox geoBoundingBox) {
        return geoBoundingBox == null || geoBoundingBox.isUnbounded() ? new UnboundedGeoHashGridTiler(precision) : new BoundedGeoHashGridTiler(precision, geoBoundingBox);
    }

    protected abstract boolean validHash(String var1);

    @Override
    public long encode(double x, double y) {
        return Geohash.longEncode((double)x, (double)y, (int)this.precision);
    }

    @Override
    public int setValues(GeoShapeCellValues values, GeoShapeValues.GeoShapeValue geoValue) throws IOException {
        long dY;
        if (this.precision == 0) {
            return 1;
        }
        ShapeValues.BoundingBox bounds = geoValue.boundingBox();
        assert (bounds.minX() <= bounds.maxX());
        if (bounds.minX() == bounds.maxX() && bounds.minY() == bounds.maxY()) {
            return this.setValue(values, geoValue, Geohash.stringEncode((double)bounds.minX(), (double)bounds.minY(), (int)this.precision), 0);
        }
        long dX = (long)Math.ceil((bounds.maxX() - bounds.minX()) / Geohash.lonWidthInDegrees((int)this.precision));
        if (dX * (dY = (long)Math.ceil((bounds.maxY() - bounds.minY()) / Geohash.latHeightInDegrees((int)this.precision))) <= 32L * (long)this.precision) {
            return this.setValuesByBruteForceScan(values, geoValue, bounds);
        }
        return this.setValuesByRasterization("", values, 0, geoValue);
    }

    int setValuesByBruteForceScan(GeoShapeCellValues values, GeoShapeValues.GeoShapeValue geoValue, ShapeValues.BoundingBox bounds) throws IOException {
        String stop = Geohash.stringEncode((double)bounds.maxX(), (double)bounds.maxY(), (int)this.precision);
        String firstInRow = null;
        String lastInRow = null;
        int idx = 0;
        do {
            lastInRow = GeoHashGridTiler.moveDown(lastInRow, this.precision, bounds.maxX(), bounds.minY());
            String current = null;
            do {
                current = current == null ? (firstInRow = GeoHashGridTiler.moveDown(firstInRow, this.precision, bounds.minX(), bounds.minY())) : Geohash.getNeighbor(current, (int)this.precision, (int)1, (int)0);
                idx = this.setValue(values, geoValue, current, idx);
            } while (!current.equals(lastInRow));
        } while (!lastInRow.equals(stop));
        return idx;
    }

    private static String moveDown(String hash, int precision, double x, double y) {
        return hash == null ? Geohash.stringEncode((double)x, (double)y, (int)precision) : Geohash.getNeighbor((String)hash, (int)precision, (int)0, (int)1);
    }

    private int setValue(GeoShapeCellValues docValues, GeoShapeValues.GeoShapeValue geoValue, String hash, int idx) throws IOException {
        if (this.relateTile(geoValue, hash) != GeoRelation.QUERY_DISJOINT) {
            docValues.resizeCell(idx + 1);
            docValues.add(idx++, Geohash.longEncode((String)hash));
        }
        return idx;
    }

    private GeoRelation relateTile(GeoShapeValues.GeoShapeValue geoValue, String hash) throws IOException {
        if (this.validHash(hash)) {
            Rectangle rectangle = Geohash.toBoundingBox((String)hash);
            int minX = GeoEncodingUtils.encodeLongitude((double)rectangle.getMinLon());
            int minY = GeoEncodingUtils.encodeLatitude((double)rectangle.getMinLat());
            int maxX = GeoEncodingUtils.encodeLongitude((double)rectangle.getMaxLon());
            int maxY = GeoEncodingUtils.encodeLatitude((double)rectangle.getMaxLat());
            return geoValue.relate(minX, maxX == Integer.MAX_VALUE ? maxX : maxX - 1, minY, maxY == Integer.MAX_VALUE ? maxY : maxY - 1);
        }
        return GeoRelation.QUERY_DISJOINT;
    }

    int setValuesByRasterization(String hash, GeoShapeCellValues values, int valuesIndex, GeoShapeValues.GeoShapeValue geoValue) throws IOException {
        String[] hashes;
        for (String s : hashes = Geohash.getSubGeohashes((String)hash)) {
            GeoRelation relation = this.relateTile(geoValue, s);
            if (relation == GeoRelation.QUERY_INSIDE) {
                if (s.length() == this.precision) {
                    values.resizeCell(valuesIndex + 1);
                    values.add(valuesIndex++, Geohash.longEncode((String)s));
                    continue;
                }
                int numTilesAtPrecision = this.getNumTilesAtPrecision(this.precision, hash.length());
                values.resizeCell(this.getNewSize(valuesIndex, numTilesAtPrecision + 1));
                valuesIndex = this.setValuesForFullyContainedTile(s, values, valuesIndex, this.precision);
                continue;
            }
            if (relation == GeoRelation.QUERY_DISJOINT) continue;
            if (s.length() == this.precision) {
                values.resizeCell(valuesIndex + 1);
                values.add(valuesIndex++, Geohash.longEncode((String)s));
                continue;
            }
            valuesIndex = this.setValuesByRasterization(s, values, valuesIndex, geoValue);
        }
        return valuesIndex;
    }

    private int getNewSize(int valuesIndex, int increment) {
        long newSize = (long)valuesIndex + (long)increment;
        if (newSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Tile aggregation array overflow");
        }
        return (int)newSize;
    }

    private int getNumTilesAtPrecision(int finalPrecision, int currentPrecision) {
        long numTilesAtPrecision = Math.min((long)Math.pow(32.0, finalPrecision - currentPrecision) + 1L, this.getMaxCells());
        if (numTilesAtPrecision > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Tile aggregation array overflow");
        }
        return (int)numTilesAtPrecision;
    }

    int setValuesForFullyContainedTile(String hash, GeoShapeCellValues values, int valuesIndex, int targetPrecision) {
        String[] hashes;
        for (String s : hashes = Geohash.getSubGeohashes((String)hash)) {
            if (!this.validHash(s)) continue;
            if (s.length() == targetPrecision) {
                values.add(valuesIndex++, Geohash.longEncode((String)s));
                continue;
            }
            valuesIndex = this.setValuesForFullyContainedTile(s, values, valuesIndex, targetPrecision);
        }
        return valuesIndex;
    }

    private static class UnboundedGeoHashGridTiler
    extends GeoHashGridTiler {
        private final long maxHashes;

        UnboundedGeoHashGridTiler(int precision) {
            super(precision);
            this.maxHashes = (long)Math.pow(32.0, precision);
        }

        @Override
        protected boolean validHash(String hash) {
            return true;
        }

        @Override
        protected long getMaxCells() {
            return this.maxHashes;
        }
    }

    private static class BoundedGeoHashGridTiler
    extends GeoHashGridTiler {
        private final GeoHashBoundedPredicate predicate;

        BoundedGeoHashGridTiler(int precision, GeoBoundingBox bbox) {
            super(precision);
            this.predicate = new GeoHashBoundedPredicate(precision, bbox);
        }

        @Override
        protected long getMaxCells() {
            return this.predicate.getMaxHashes();
        }

        @Override
        protected boolean validHash(String hash) {
            return this.predicate.validHash(hash);
        }
    }
}

