/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.url;

import java.io.Closeable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.url.URLBlobStore;
import org.elasticsearch.common.blobstore.url.http.URLHttpClient;
import org.elasticsearch.common.blobstore.url.http.URLHttpClientSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.URIPattern;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class URLRepository
extends BlobStoreRepository {
    private static final Logger logger = LogManager.getLogger(URLRepository.class);
    public static final String TYPE = "url";
    public static final Setting<List<String>> SUPPORTED_PROTOCOLS_SETTING;
    public static final Setting<List<URIPattern>> ALLOWED_URLS_SETTING;
    public static final Setting<URL> URL_SETTING;
    public static final Setting<URL> REPOSITORIES_URL_SETTING;
    private final List<String> supportedProtocols;
    private final URIPattern[] urlWhiteList;
    private final Environment environment;
    private final URL url;
    private final URLHttpClient httpClient;
    private final URLHttpClientSettings httpClientSettings;

    public URLRepository(ProjectId projectId, RepositoryMetadata metadata, Environment environment, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings, URLHttpClient.Factory httpClientFactory) {
        super(projectId, metadata, namedXContentRegistry, clusterService, bigArrays, recoverySettings, BlobPath.EMPTY);
        if (!URL_SETTING.exists(metadata.settings()) && !REPOSITORIES_URL_SETTING.exists(environment.settings())) {
            throw new RepositoryException(metadata.name(), "missing url", new Object[0]);
        }
        this.environment = environment;
        this.supportedProtocols = (List)SUPPORTED_PROTOCOLS_SETTING.get(environment.settings());
        this.urlWhiteList = ((List)ALLOWED_URLS_SETTING.get(environment.settings())).toArray(new URIPattern[0]);
        this.url = URL_SETTING.exists(metadata.settings()) ? (URL)URL_SETTING.get(metadata.settings()) : (URL)REPOSITORIES_URL_SETTING.get(environment.settings());
        this.httpClientSettings = URLHttpClientSettings.fromSettings(metadata.settings());
        this.httpClient = httpClientFactory.create(this.httpClientSettings);
    }

    protected BlobStore createBlobStore() {
        URL normalizedURL = this.checkURL(this.url);
        return new URLBlobStore(this.environment.settings(), normalizedURL, this.httpClient, this.httpClientSettings);
    }

    protected BlobContainer blobContainer() {
        return super.blobContainer();
    }

    protected BlobStore getBlobStore() {
        return super.getBlobStore();
    }

    private URL checkURL(URL urlToCheck) {
        String protocol = urlToCheck.getProtocol();
        if (protocol == null) {
            throw new RepositoryException(this.getMetadata().name(), "unknown url protocol from URL [" + String.valueOf(urlToCheck) + "]", new Object[0]);
        }
        for (String supportedProtocol : this.supportedProtocols) {
            if (!supportedProtocol.equals(protocol)) continue;
            try {
                if (URIPattern.match((URIPattern[])this.urlWhiteList, (URI)urlToCheck.toURI())) {
                    return urlToCheck;
                }
            }
            catch (URISyntaxException ex) {
                logger.warn("cannot parse the specified url [{}]", (Object)urlToCheck);
                throw new RepositoryException(this.getMetadata().name(), "cannot parse the specified url [" + String.valueOf(urlToCheck) + "]", new Object[0]);
            }
            URL normalizedUrl = this.environment.resolveRepoURL(urlToCheck);
            if (normalizedUrl == null) {
                String logMessage = "The specified url [{}] doesn't start with any repository paths specified by the path.repo setting or by {} setting: [{}] ";
                logger.warn(logMessage, (Object)urlToCheck, (Object)ALLOWED_URLS_SETTING.getKey(), (Object)this.environment.repoDirs());
                String exceptionMessage = "file url [" + String.valueOf(urlToCheck) + "] doesn't match any of the locations specified by path.repo or " + ALLOWED_URLS_SETTING.getKey();
                throw new RepositoryException(this.getMetadata().name(), exceptionMessage, new Object[0]);
            }
            return normalizedUrl;
        }
        throw new RepositoryException(this.getMetadata().name(), "unsupported url protocol [" + protocol + "] from URL [" + String.valueOf(urlToCheck) + "]", new Object[0]);
    }

    public boolean isReadOnly() {
        return true;
    }

    private static URL parseURL(String s) {
        try {
            return new URL(s);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to parse URL repository setting", e);
        }
    }

    protected void doClose() {
        IOUtils.closeWhileHandlingException((Closeable)this.httpClient);
        super.doClose();
    }

    static {
        assert (TYPE.equals(TYPE));
        SUPPORTED_PROTOCOLS_SETTING = Setting.stringListSetting((String)"repositories.url.supported_protocols", List.of("http", "https", "ftp", "file", "jar"), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        ALLOWED_URLS_SETTING = Setting.listSetting((String)"repositories.url.allowed_urls", Collections.emptyList(), URIPattern::new, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        URL_SETTING = new Setting(TYPE, "http:", URLRepository::parseURL, new Setting.Property[]{Setting.Property.NodeScope});
        REPOSITORIES_URL_SETTING = new Setting("repositories.url.url", s -> s.get("repositories.uri.url", "http:"), URLRepository::parseURL, new Setting.Property[]{Setting.Property.NodeScope});
    }
}

