/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.function.Consumer;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.SinkOperator;

public class PageConsumerOperator
extends SinkOperator {
    private final Consumer<Page> pageConsumer;
    boolean finished = false;

    public PageConsumerOperator(Consumer<Page> pageConsumer) {
        this.pageConsumer = pageConsumer;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    @Override
    protected void doAddInput(Page page) {
        this.pageConsumer.accept(page);
    }

    @Override
    public void close() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("pageConsumer=").append(this.pageConsumer);
        sb.append("]");
        return sb.toString();
    }
}

