/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.compute.Describable;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.DriverEarlyTerminationException;
import org.elasticsearch.compute.operator.DriverProfile;
import org.elasticsearch.compute.operator.DriverScheduler;
import org.elasticsearch.compute.operator.DriverSleeps;
import org.elasticsearch.compute.operator.DriverStatus;
import org.elasticsearch.compute.operator.IsBlockedResult;
import org.elasticsearch.compute.operator.LimitOperator;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.OperatorStatus;
import org.elasticsearch.compute.operator.SinkOperator;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.compute.operator.exchange.ExchangeSinkOperator;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.TaskCancelledException;

public class Driver
implements Releasable,
Describable {
    public static final TimeValue DEFAULT_TIME_BEFORE_YIELDING = TimeValue.timeValueMinutes((long)5L);
    public static final int DEFAULT_MAX_ITERATIONS = 10000;
    public static final TimeValue DEFAULT_STATUS_INTERVAL = TimeValue.timeValueSeconds((long)1L);
    private final String sessionId;
    private final String shortDescription;
    private final long startTime;
    private final long startNanos;
    private final DriverContext driverContext;
    private final Supplier<String> description;
    private List<Operator> activeOperators;
    private final List<OperatorStatus> statusOfCompletedOperators = new ArrayList<OperatorStatus>();
    private final Releasable releasable;
    private final long statusNanos;
    private final AtomicReference<String> cancelReason = new AtomicReference();
    private final AtomicBoolean started = new AtomicBoolean();
    private final SubscribableListener<Void> completionListener = new SubscribableListener();
    private final DriverScheduler scheduler = new DriverScheduler();
    private final AtomicReference<DriverStatus> status;
    private long finishNanos;

    public Driver(String sessionId, String shortDescription, String clusterName, String nodeName, long startTime, long startNanos, DriverContext driverContext, Supplier<String> description, SourceOperator source, List<Operator> intermediateOperators, SinkOperator sink, TimeValue statusInterval, Releasable releasable) {
        this.sessionId = sessionId;
        this.shortDescription = shortDescription;
        this.startTime = startTime;
        this.startNanos = startNanos;
        this.driverContext = driverContext;
        this.description = description;
        this.activeOperators = new ArrayList<Operator>();
        this.activeOperators.add(source);
        this.activeOperators.addAll(intermediateOperators);
        this.activeOperators.add(sink);
        this.statusNanos = statusInterval.nanos();
        this.releasable = releasable;
        this.status = new AtomicReference<DriverStatus>(new DriverStatus(sessionId, shortDescription, clusterName, nodeName, startTime, System.currentTimeMillis(), 0L, 0L, DriverStatus.Status.QUEUED, List.of(), List.of(), DriverSleeps.empty()));
    }

    public DriverContext driverContext() {
        return this.driverContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SubscribableListener<Void> run(TimeValue maxTime, int maxIterations, LongSupplier nowSupplier) {
        this.updateStatus(0L, 0, DriverStatus.Status.RUNNING, "driver running");
        long maxTimeNanos = maxTime.nanos();
        long startTime = nowSupplier.getAsLong();
        long nextStatus = startTime + this.statusNanos;
        int totalIterationsThisRun = 0;
        int iterationsSinceLastStatusUpdate = 0;
        long lastStatusUpdateTime = startTime;
        while (true) {
            IsBlockedResult isBlocked;
            block14: {
                isBlocked = Operator.NOT_BLOCKED;
                try {
                    assert (this.driverContext.assertBeginRunLoop());
                    isBlocked = this.runSingleLoopIteration();
                }
                catch (DriverEarlyTerminationException unused) {
                    this.closeEarlyFinishedOperators(this.activeOperators.listIterator(this.activeOperators.size()));
                    assert (this.isFinished()) : "not finished after early termination";
                }
                finally {
                    if ($assertionsDisabled || this.driverContext.assertEndRunLoop()) break block14;
                    throw new AssertionError();
                }
            }
            ++totalIterationsThisRun;
            ++iterationsSinceLastStatusUpdate;
            long now = nowSupplier.getAsLong();
            if (!isBlocked.listener().isDone()) {
                this.updateStatus(now - lastStatusUpdateTime, iterationsSinceLastStatusUpdate, DriverStatus.Status.ASYNC, isBlocked.reason());
                return isBlocked.listener();
            }
            if (this.isFinished()) {
                this.finishNanos = now;
                this.updateStatus(this.finishNanos - lastStatusUpdateTime, iterationsSinceLastStatusUpdate, DriverStatus.Status.DONE, "driver done");
                this.driverContext.finish();
                Releasables.close((Releasable[])new Releasable[]{this.releasable, this.driverContext.getSnapshot()});
                return Operator.NOT_BLOCKED.listener();
            }
            if (totalIterationsThisRun >= maxIterations) {
                this.updateStatus(now - lastStatusUpdateTime, iterationsSinceLastStatusUpdate, DriverStatus.Status.WAITING, "driver iterations");
                return Operator.NOT_BLOCKED.listener();
            }
            if (now - startTime >= maxTimeNanos) {
                this.updateStatus(now - lastStatusUpdateTime, iterationsSinceLastStatusUpdate, DriverStatus.Status.WAITING, "driver time");
                return Operator.NOT_BLOCKED.listener();
            }
            if (now <= nextStatus) continue;
            this.updateStatus(now - lastStatusUpdateTime, iterationsSinceLastStatusUpdate, DriverStatus.Status.RUNNING, "driver running");
            iterationsSinceLastStatusUpdate = 0;
            lastStatusUpdateTime = now;
            nextStatus = now + this.statusNanos;
        }
    }

    private boolean isFinished() {
        return this.activeOperators.isEmpty();
    }

    public void close() {
        this.drainAndCloseOperators(null);
    }

    public void abort(Exception reason, ActionListener<Void> listener) {
        this.finishNanos = System.nanoTime();
        this.completionListener.addListener(listener);
        if (this.started.compareAndSet(false, true)) {
            this.drainAndCloseOperators(reason);
            this.completionListener.onFailure(reason);
        } else {
            this.cancel(reason.getMessage());
        }
    }

    private IsBlockedResult runSingleLoopIteration() {
        this.driverContext.checkForEarlyTermination();
        boolean movedPage = false;
        ListIterator<Operator> iterator = this.activeOperators.listIterator();
        while (iterator.hasNext()) {
            Operator op = iterator.next();
            if (!iterator.hasNext()) break;
            Operator nextOp = this.activeOperators.get(iterator.nextIndex());
            if (!op.isBlocked().listener().isDone()) continue;
            if (!op.isFinished() && nextOp.needsInput()) {
                this.driverContext.checkForEarlyTermination();
                assert (!nextOp.isFinished() || nextOp instanceof ExchangeSinkOperator || nextOp instanceof LimitOperator) : "next operator should not be finished yet: " + String.valueOf(nextOp);
                Page page = op.getOutput();
                if (page != null) {
                    if (page.getPositionCount() == 0) {
                        page.releaseBlocks();
                    } else {
                        try {
                            this.driverContext.checkForEarlyTermination();
                        }
                        catch (DriverEarlyTerminationException | TaskCancelledException e) {
                            page.releaseBlocks();
                            throw e;
                        }
                        nextOp.addInput(page);
                        movedPage = true;
                    }
                }
            }
            if (!op.isFinished()) continue;
            this.driverContext.checkForEarlyTermination();
            int originalIndex = iterator.previousIndex();
            int index = this.closeEarlyFinishedOperators(iterator);
            if (index < 0) continue;
            iterator = new ArrayList<Operator>(this.activeOperators).listIterator(originalIndex - index);
        }
        this.closeEarlyFinishedOperators(this.activeOperators.listIterator(this.activeOperators.size()));
        if (!movedPage) {
            return Driver.oneOf(this.activeOperators.stream().map(Operator::isBlocked).filter(laf -> !laf.listener().isDone()).collect(Collectors.toList()));
        }
        return Operator.NOT_BLOCKED;
    }

    private int closeEarlyFinishedOperators(ListIterator<Operator> operators) {
        ListIterator<Operator> iterator = this.activeOperators.listIterator(operators.nextIndex());
        while (iterator.hasPrevious()) {
            if (!iterator.previous().isFinished()) continue;
            int index = iterator.nextIndex();
            Iterator<Operator> finishedOperators = this.activeOperators.subList(0, index + 1).iterator();
            while (finishedOperators.hasNext()) {
                Operator op = finishedOperators.next();
                this.statusOfCompletedOperators.add(new OperatorStatus(op.toString(), op.status()));
                op.close();
                finishedOperators.remove();
            }
            if (!this.activeOperators.isEmpty()) {
                Operator newRootOperator = this.activeOperators.get(0);
                newRootOperator.finish();
            }
            return index;
        }
        return -1;
    }

    public void cancel(String reason) {
        if (this.cancelReason.compareAndSet(null, reason)) {
            this.scheduler.runPendingTasks();
        }
    }

    public static void start(ThreadContext threadContext, Executor executor, Driver driver, int maxIterations, ActionListener<Void> listener) {
        driver.completionListener.addListener(listener);
        if (driver.started.compareAndSet(false, true)) {
            driver.updateStatus(0L, 0, DriverStatus.Status.STARTING, "driver starting");
            Driver.initializeEarlyTerminationChecker(driver);
            Driver.schedule(DEFAULT_TIME_BEFORE_YIELDING, maxIterations, threadContext, executor, driver, driver.completionListener);
        }
    }

    private static void initializeEarlyTerminationChecker(Driver driver) {
        Operator operator;
        AtomicBoolean earlyFinished = new AtomicBoolean();
        driver.driverContext.initializeEarlyTerminationChecker(() -> {
            String reason = driver.cancelReason.get();
            if (reason != null) {
                throw new TaskCancelledException(reason);
            }
            if (earlyFinished.get()) {
                throw new DriverEarlyTerminationException("Exchange sink is closed");
            }
        });
        if (!driver.activeOperators.isEmpty() && (operator = driver.activeOperators.getLast()) instanceof ExchangeSinkOperator) {
            ExchangeSinkOperator sinkOperator = (ExchangeSinkOperator)operator;
            sinkOperator.addCompletionListener((ActionListener<Void>)ActionListener.running(() -> {
                earlyFinished.set(true);
                driver.scheduler.runPendingTasks();
            }));
        }
    }

    private void drainAndCloseOperators(@Nullable Exception e) {
        Iterator<Operator> itr = this.activeOperators.iterator();
        while (itr.hasNext()) {
            block3: {
                try {
                    Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{itr.next()});
                }
                catch (Exception x) {
                    if (e == null) break block3;
                    e.addSuppressed(x);
                }
            }
            itr.remove();
        }
        this.driverContext.finish();
        Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{this.releasable, this.driverContext.getSnapshot()});
    }

    private static void schedule(final TimeValue maxTime, final int maxIterations, final ThreadContext threadContext, final Executor executor, final Driver driver, final ActionListener<Void> listener) {
        AbstractRunnable task = new AbstractRunnable(){

            protected void doRun() {
                SubscribableListener<Void> fut = driver.run(maxTime, maxIterations, System::nanoTime);
                if (driver.isFinished()) {
                    this.onComplete((ActionListener<Void>)listener);
                    return;
                }
                if (fut.isDone()) {
                    Driver.schedule(maxTime, maxIterations, threadContext, executor, driver, (ActionListener<Void>)listener);
                } else {
                    ActionListener readyListener = ActionListener.wrap(ignored -> Driver.schedule(maxTime, maxIterations, threadContext, executor, driver, (ActionListener<Void>)listener), this::onFailure);
                    fut.addListener((ActionListener)ContextPreservingActionListener.wrapPreservingContext((ActionListener)readyListener, (ThreadContext)threadContext));
                    driver.scheduler.addOrRunDelayedTask(() -> fut.onResponse(null));
                }
            }

            public void onFailure(Exception e) {
                driver.drainAndCloseOperators(e);
                this.onComplete((ActionListener<Void>)ActionListener.running(() -> listener.onFailure(e)));
            }

            void onComplete(ActionListener<Void> listener2) {
                driver.driverContext.waitForAsyncActions((ActionListener<Void>)ContextPreservingActionListener.wrapPreservingContext(listener2, (ThreadContext)threadContext));
            }
        };
        driver.scheduler.scheduleOrRunTask(executor, task);
    }

    private static IsBlockedResult oneOf(List<IsBlockedResult> results) {
        if (results.isEmpty()) {
            return Operator.NOT_BLOCKED;
        }
        if (results.size() == 1) {
            return results.get(0);
        }
        SubscribableListener oneOf = new SubscribableListener();
        StringBuilder reason = new StringBuilder();
        for (IsBlockedResult r : results) {
            r.listener().addListener((ActionListener)oneOf);
            if (!reason.isEmpty()) {
                reason.append(" OR ");
            }
            reason.append(r.reason());
        }
        return new IsBlockedResult((SubscribableListener<Void>)oneOf, reason.toString());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[activeOperators=" + String.valueOf(this.activeOperators) + "]";
    }

    @Override
    public String describe() {
        return this.description.get();
    }

    public String sessionId() {
        return this.sessionId;
    }

    public DriverStatus status() {
        return this.status.get();
    }

    public DriverProfile profile() {
        DriverStatus status = this.status();
        if (status.status() != DriverStatus.Status.DONE) {
            throw new IllegalStateException("can only get profile from finished driver");
        }
        return new DriverProfile(status.description(), status.clusterName(), status.nodeName(), status.started(), status.lastUpdated(), this.finishNanos - this.startNanos, status.cpuNanos(), status.iterations(), status.completedOperators(), status.sleeps());
    }

    private void updateStatus(long extraCpuNanos, int extraIterations, DriverStatus.Status status, String reason) {
        this.status.getAndUpdate(prev -> {
            long now = System.currentTimeMillis();
            DriverSleeps sleeps = prev.sleeps();
            block0 : switch (status) {
                case ASYNC: 
                case WAITING: {
                    sleeps = sleeps.sleep(reason, now);
                    return new DriverStatus(this.sessionId, this.shortDescription, prev.clusterName(), prev.nodeName(), this.startTime, now, prev.cpuNanos() + extraCpuNanos, prev.iterations() + (long)extraIterations, status, List.copyOf(this.statusOfCompletedOperators), this.activeOperators.stream().map(op -> new OperatorStatus(op.toString(), op.status())).toList(), sleeps);
                }
                case RUNNING: {
                    switch (prev.status()) {
                        case ASYNC: 
                        case WAITING: {
                            sleeps = sleeps.wake(now);
                            break block0;
                        }
                        case STARTING: {
                            if (extraIterations != 0) return new DriverStatus(this.sessionId, this.shortDescription, prev.clusterName(), prev.nodeName(), this.startTime, now, prev.cpuNanos() + extraCpuNanos, prev.iterations() + (long)extraIterations, status, List.copyOf(this.statusOfCompletedOperators), this.activeOperators.stream().map(op -> new OperatorStatus(op.toString(), op.status())).toList(), sleeps);
                            return prev;
                        }
                    }
                }
            }
            return new DriverStatus(this.sessionId, this.shortDescription, prev.clusterName(), prev.nodeName(), this.startTime, now, prev.cpuNanos() + extraCpuNanos, prev.iterations() + (long)extraIterations, status, List.copyOf(this.statusOfCompletedOperators), this.activeOperators.stream().map(op -> new OperatorStatus(op.toString(), op.status())).toList(), sleeps);
        });
    }
}

