/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.compute.aggregation.AbstractArrayState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

final class LongArrayState
extends AbstractArrayState
implements GroupingAggregatorState {
    private final long init;
    private LongArray values;

    LongArrayState(BigArrays bigArrays, long init) {
        super(bigArrays);
        this.values = bigArrays.newLongArray(1L, false);
        this.values.set(0L, init);
        this.init = init;
    }

    long get(int groupId) {
        return this.values.get((long)groupId);
    }

    long getOrDefault(int groupId) {
        return (long)groupId < this.values.size() ? this.values.get((long)groupId) : this.init;
    }

    void set(int groupId, long value) {
        this.ensureCapacity(groupId);
        this.values.set((long)groupId, value);
        this.trackGroupId(groupId);
    }

    void increment(int groupId, long value) {
        this.ensureCapacity(groupId);
        this.values.increment((long)groupId, value);
        this.trackGroupId(groupId);
    }

    Block toValuesBlock(IntVector selected, DriverContext driverContext) {
        if (!this.trackingGroupIds()) {
            try (LongVector.FixedBuilder builder = driverContext.blockFactory().newLongVectorFixedBuilder(selected.getPositionCount());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    builder.appendLong(i, this.values.get((long)selected.getInt(i)));
                }
                LongBlock i = builder.build().asBlock();
                return i;
            }
        }
        try (LongBlock.Builder builder = driverContext.blockFactory().newLongBlockBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                if (this.hasValue(group)) {
                    builder.appendLong(this.values.get((long)group));
                    continue;
                }
                builder.appendNull();
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    private void ensureCapacity(int groupId) {
        if ((long)groupId >= this.values.size()) {
            long prevSize = this.values.size();
            this.values = this.bigArrays.grow(this.values, (long)(groupId + 1));
            this.values.fill(prevSize, this.values.size(), this.init);
        }
    }

    @Override
    public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        assert (blocks.length >= offset + 2);
        try (LongBlock.Builder valuesBuilder = driverContext.blockFactory().newLongBlockBuilder(selected.getPositionCount());
             BooleanVector.FixedBuilder hasValueBuilder = driverContext.blockFactory().newBooleanVectorFixedBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                if ((long)group < this.values.size()) {
                    valuesBuilder.appendLong(this.values.get((long)group));
                } else {
                    valuesBuilder.appendLong(0L);
                }
                hasValueBuilder.appendBoolean(i, this.hasValue(group));
            }
            blocks[offset + 0] = valuesBuilder.build();
            blocks[offset + 1] = hasValueBuilder.build().asBlock();
        }
    }

    @Override
    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.values, () -> super.close()});
    }
}

