/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;

public class PluginSecurity {
    public static final String ENTITLEMENTS_DESCRIPTION_URL = "https://www.elastic.co/guide/en/elasticsearch/plugins/current/creating-classic-plugins.html";

    static void confirmPolicyExceptions(Terminal terminal, Set<String> entitlements, boolean batch) throws UserException {
        ArrayList<String> requested = new ArrayList<String>(entitlements);
        if (requested.isEmpty()) {
            terminal.println(Terminal.Verbosity.NORMAL, (CharSequence)"WARNING: plugin has a policy file with no additional entitlements. Double check this is intentional.");
        } else {
            Collections.sort(requested);
            if (terminal.isHeadless()) {
                terminal.errorPrintln("WARNING: plugin requires additional entitlements: [" + requested.stream().map(each -> "'" + each + "'").collect(Collectors.joining(", ")) + "]");
                terminal.errorPrintln("See https://www.elastic.co/guide/en/elasticsearch/plugins/current/creating-classic-plugins.html for descriptions of what these entitlements allow and the associated risks.");
            } else {
                terminal.errorPrintln(Terminal.Verbosity.NORMAL, "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                terminal.errorPrintln(Terminal.Verbosity.NORMAL, "@     WARNING: plugin requires additional entitlements    @");
                terminal.errorPrintln(Terminal.Verbosity.NORMAL, "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                for (String entitlement : requested) {
                    terminal.errorPrintln(Terminal.Verbosity.NORMAL, "* " + entitlement);
                }
                terminal.errorPrintln(Terminal.Verbosity.NORMAL, "See https://www.elastic.co/guide/en/elasticsearch/plugins/current/creating-classic-plugins.html");
                terminal.errorPrintln(Terminal.Verbosity.NORMAL, "for descriptions of what these entitlements allow and the associated risks.");
                if (!batch) {
                    PluginSecurity.prompt(terminal);
                }
            }
        }
    }

    private static void prompt(Terminal terminal) throws UserException {
        terminal.println(Terminal.Verbosity.NORMAL, (CharSequence)"");
        String text = terminal.readText("Continue with installation? [y/N]");
        if (!text.equalsIgnoreCase("y")) {
            throw new UserException(65, "installation aborted by user");
        }
    }
}

