/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.multiproject;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.multiproject.action.DeleteProjectAction;
import org.elasticsearch.multiproject.action.PutProjectAction;
import org.elasticsearch.multiproject.action.RestDeleteProjectAction;
import org.elasticsearch.multiproject.action.RestPutProjectAction;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestHeaderDefinition;
import org.elasticsearch.threadpool.ThreadPool;

public class TestOnlyMultiProjectPlugin
extends Plugin
implements ActionPlugin {
    public static final Setting<Boolean> MULTI_PROJECT_ENABLED = Setting.boolSetting((String)"test.multi_project.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(TestOnlyMultiProjectPlugin.class);
    public final SetOnce<ThreadPool> threadPool = new SetOnce();
    private final boolean multiProjectEnabled;

    public TestOnlyMultiProjectPlugin(Settings settings) {
        this.multiProjectEnabled = (Boolean)MULTI_PROJECT_ENABLED.get(settings);
        logger.info("multi-project is [{}]", new Object[]{this.multiProjectEnabled ? "enabled" : "disabled"});
    }

    public Collection<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        if (this.multiProjectEnabled) {
            return List.of(new RestPutProjectAction(), new RestDeleteProjectAction());
        }
        return List.of();
    }

    public Collection<ActionPlugin.ActionHandler> getActions() {
        if (this.multiProjectEnabled) {
            return List.of(new ActionPlugin.ActionHandler((ActionType)PutProjectAction.INSTANCE, PutProjectAction.TransportPutProjectAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteProjectAction.INSTANCE, DeleteProjectAction.TransportDeleteProjectAction.class));
        }
        return List.of();
    }

    public Collection<RestHeaderDefinition> getRestHeaders() {
        if (this.multiProjectEnabled) {
            return Set.of(new RestHeaderDefinition("X-Elastic-Project-Id", false));
        }
        return Set.of();
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        this.threadPool.set((Object)services.threadPool());
        return List.of();
    }

    public List<Setting<?>> getSettings() {
        return List.of(MULTI_PROJECT_ENABLED);
    }

    public ThreadPool getThreadPool() {
        return (ThreadPool)this.threadPool.get();
    }

    public boolean multiProjectEnabled() {
        return this.multiProjectEnabled;
    }
}

