/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.migrate.task.ReindexDataStreamPersistentTaskState;
import org.elasticsearch.xpack.migrate.task.ReindexDataStreamStatus;

public class ReindexDataStreamTask
extends AllocatedPersistentTask {
    public static final String TASK_NAME = "reindex-data-stream";
    private final ClusterService clusterService;
    private final long persistentTaskStartTime;
    private final int initialTotalIndices;
    private final int initialTotalIndicesToBeUpgraded;
    private boolean isCompleteLocally = false;
    private volatile Exception exception;
    private final Set<String> inProgress = Collections.synchronizedSet(new HashSet());
    private final AtomicInteger pending = new AtomicInteger();
    private final List<Tuple<String, Exception>> errors = Collections.synchronizedList(new ArrayList());
    private final RunOnce completeTask;

    public ReindexDataStreamTask(ClusterService clusterService, long persistentTaskStartTime, int initialTotalIndices, int initialTotalIndicesToBeUpgraded, long id, String type, String action, String description, TaskId parentTask, Map<String, String> headers) {
        super(id, type, action, description, parentTask, headers);
        this.clusterService = clusterService;
        this.persistentTaskStartTime = persistentTaskStartTime;
        this.initialTotalIndices = initialTotalIndices;
        this.initialTotalIndicesToBeUpgraded = initialTotalIndicesToBeUpgraded;
        this.pending.set(initialTotalIndicesToBeUpgraded);
        this.completeTask = new RunOnce(() -> {
            if (this.exception == null) {
                this.markAsCompleted();
            } else {
                this.markAsFailed(this.exception);
            }
        });
    }

    public ReindexDataStreamStatus getStatus() {
        boolean isComplete;
        int totalIndices = this.initialTotalIndices;
        int totalIndicesToBeUpgraded = this.initialTotalIndicesToBeUpgraded;
        PersistentTasksCustomMetadata.PersistentTask persistentTask = PersistentTasksCustomMetadata.getTaskWithId((ClusterState)this.clusterService.state(), (String)this.getPersistentTaskId());
        if (persistentTask != null) {
            ReindexDataStreamPersistentTaskState state = (ReindexDataStreamPersistentTaskState)persistentTask.getState();
            if (state != null) {
                isComplete = state.isComplete();
                if (state.totalIndices() != null && state.totalIndicesToBeUpgraded() != null) {
                    totalIndices = Math.toIntExact(state.totalIndices().intValue());
                    totalIndicesToBeUpgraded = Math.toIntExact(state.totalIndicesToBeUpgraded().intValue());
                }
            } else {
                isComplete = false;
            }
        } else {
            isComplete = false;
        }
        return new ReindexDataStreamStatus(this.persistentTaskStartTime, totalIndices, totalIndicesToBeUpgraded, isComplete, this.exception, this.inProgress, this.pending.get(), this.errors);
    }

    public void allReindexesCompleted(ThreadPool threadPool, TimeValue timeToLive) {
        this.isCompleteLocally = true;
        if (this.isCancelled()) {
            this.completeTask.run();
        } else {
            threadPool.schedule((Runnable)this.completeTask, timeToLive, (Executor)threadPool.generic());
        }
    }

    public void taskFailed(ThreadPool threadPool, TimeValue timeToLive, Exception e) {
        this.exception = e;
        this.allReindexesCompleted(threadPool, timeToLive);
    }

    public void reindexSucceeded(String index) {
        this.inProgress.remove(index);
    }

    public void reindexFailed(String index, Exception error) {
        this.errors.add((Tuple<String, Exception>)Tuple.tuple((Object)index, (Object)error));
        this.inProgress.remove(index);
    }

    public void incrementInProgressIndicesCount(String index) {
        this.inProgress.add(index);
        this.pending.decrementAndGet();
    }

    private boolean isCompleteInClusterState() {
        PersistentTasksCustomMetadata persistentTasksCustomMetadata = (PersistentTasksCustomMetadata)this.clusterService.state().getMetadata().getProject().custom("persistent_tasks");
        PersistentTasksCustomMetadata.PersistentTask persistentTask = persistentTasksCustomMetadata.getTask(this.getPersistentTaskId());
        if (persistentTask != null) {
            ReindexDataStreamPersistentTaskState state = (ReindexDataStreamPersistentTaskState)persistentTask.getState();
            if (state != null) {
                return state.isComplete();
            }
            return false;
        }
        return false;
    }

    public void setPendingIndicesCount(int size) {
        this.pending.set(size);
    }

    public void onCancelled() {
        if (this.isCompleteInClusterState() || this.isCompleteLocally) {
            this.completeTask.run();
        }
    }
}

